/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.thread.pool.impl;

import com.irdstudio.bfp.executor.thread.Result;
import com.irdstudio.bfp.executor.thread.pool.CustomThreadPool;
import com.irdstudio.bfp.executor.thread.pool.ThreadPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCustomThreadPoolImpl
implements CustomThreadPool,
ThreadPool {
    private String threadPoolName;
    private boolean isRunning = false;
    private BlockingQueue<Callable<Result<?>>> taskQueue = new LinkedBlockingQueue();
    private BlockingQueue<Future<Result<?>>> finishQueue;
    private Map<String, Integer> execute_num = new HashMap<String, Integer>();
    private int maxTaskNum;
    private Integer liveNum = 0;
    private int successNum = 0;
    private int failureNum = 0;
    private int finished_task = 0;
    private Thread startThead;
    private static Logger logger = LoggerFactory.getLogger(DefaultCustomThreadPoolImpl.class);

    @Override
    public void start() {
        this.finishQueue = new LinkedBlockingQueue(this.maxTaskNum + 1);
        this.startThead = new Thread(() -> this.start0());
        this.startThead.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start0() {
        if (!this.isRunning) {
            this.isRunning = true;
        }
        int i = 1;
        while (this.isRunning) {
            if (!this.taskQueue.isEmpty()) {
                try {
                    while (this.liveNum >= this.maxTaskNum) {
                        this.unblock();
                        Thread.sleep(500L);
                        Thread.yield();
                    }
                    BlockingQueue<Callable<Result<?>>> blockingQueue = this.taskQueue;
                    synchronized (blockingQueue) {
                        Callable<Result<?>> callable = this.taskQueue.take();
                        Future<Result<?>> future = Executors.newSingleThreadExecutor().submit(callable);
                        String clazzName = callable.getClass().getName();
                        if (!this.execute_num.containsKey(clazzName)) {
                            this.execute_num.put(clazzName, 0);
                        }
                        this.execute_num.put(clazzName, this.execute_num.get(clazzName) + 1);
                        Object object = this.liveNum;
                        synchronized (object) {
                            Integer n = this.liveNum;
                            Integer n2 = this.liveNum = Integer.valueOf(this.liveNum + 1);
                        }
                        object = this.finishQueue;
                        synchronized (object) {
                            if (this.finishQueue.size() >= this.maxTaskNum - 1) {
                                this.releaseFinishedThread(this.finishQueue.take());
                            }
                            this.finishQueue.put(future);
                        }
                        logger.info(this.toString());
                    }
                }
                catch (Throwable e) {
                    logger.error("\u7ebf\u7a0b\u6c60\u8fd0\u884c\u7ebf\u7a0b\u5f02\u5e38!", e);
                }
            } else {
                try {
                    Thread.sleep(200L);
                    if (this.taskQueue.isEmpty()) {
                        this.unblock();
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u7ebf\u7a0b\u6c60\u91ca\u653e\u4efb\u52a1\u5f02\u5e38!", (Throwable)e);
                }
                ++i;
            }
            if (i % 1200 != 0) continue;
            logger.info(this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        BlockingQueue<Future<Result<?>>> blockingQueue = this.finishQueue;
        synchronized (blockingQueue) {
            for (Future future : this.finishQueue) {
                this.releaseFinishedThread(future);
                this.finishQueue.remove(future);
            }
            this.finishQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFinishedThread(Future<Result<?>> future) {
        block8: {
            try {
                if (future.isDone()) {
                    ++this.finished_task;
                    Result<?> result = future.get();
                    if (result.isSuccess()) {
                        ++this.successNum;
                    } else {
                        ++this.failureNum;
                    }
                    Integer n = this.liveNum;
                    synchronized (n) {
                        Integer n2 = this.liveNum;
                        Integer n3 = this.liveNum = Integer.valueOf(this.liveNum - 1);
                        break block8;
                    }
                }
                this.finishQueue.add(future);
            }
            catch (Exception e) {
                logger.error("\u7ebf\u7a0b\u6c60\u8fd0\u884c\u7ebf\u7a0b\u5f02\u5e38!", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Result<?>> add(Callable<Result<?>> task) throws Exception {
        BlockingQueue<Callable<Result<?>>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            try {
                this.taskQueue.put(task);
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1\uff1a" + task + "\u52a0\u5165\u7ebf\u7a0b\u6c60\u5931\u8d25!", (Throwable)e);
                throw e;
            }
            finally {
                this.taskQueue.notify();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Future<Result<?>>> add(Collection<Callable<Result<?>>> tasks) throws Exception {
        BlockingQueue<Callable<Result<?>>> blockingQueue = this.taskQueue;
        synchronized (blockingQueue) {
            try {
                for (Callable<Result<?>> call : tasks) {
                    this.taskQueue.put(call);
                }
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1\uff1a" + tasks + "\u52a0\u5165\u7ebf\u7a0b\u6c60\u5931\u8d25!", (Throwable)e);
            }
            finally {
                this.taskQueue.notify();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        DefaultCustomThreadPoolImpl defaultCustomThreadPoolImpl = this;
        synchronized (defaultCustomThreadPoolImpl) {
            this.toString();
            this.taskQueue.clear();
            this.unblock();
            this.execute_num.clear();
            this.startThead.stop();
        }
    }

    @Override
    public int getCurrWaitTask() {
        return this.taskQueue.size();
    }

    @Override
    public String getTreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public boolean addRunnable(Runnable task) throws Exception {
        this.add(new DefRunnable(task));
        return true;
    }

    @Override
    public boolean addRunnables(Collection<Runnable> tasks) throws Exception {
        Collection colls = tasks.parallelStream().map(s -> new DefRunnable((Runnable)s)).collect(Collectors.toList());
        this.add(colls);
        return true;
    }

    @Override
    public int getFinishNum() {
        return this.finished_task;
    }

    @Override
    public int getCurrLiveNum() {
        return this.liveNum;
    }

    @Override
    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public boolean isRunningPool() {
        return this.isRunning;
    }

    @Override
    public int getSuccessNum() {
        return this.successNum;
    }

    @Override
    public int getFailureNum() {
        return this.failureNum;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Pool name:" + this.threadPoolName);
        sb.append(" Queue number: " + this.taskQueue.size());
        sb.append(" WorkThread number:" + this.maxTaskNum);
        sb.append(" LiveThread number:" + this.liveNum);
        sb.append(" Finished task number:" + this.finished_task);
        sb.append(" Success task number:" + this.successNum);
        sb.append(" Failure task number:" + this.failureNum);
        sb.append(" Wait task number:" + this.taskQueue.size());
        sb.append(" Execute number:" + this.execute_num);
        return sb.toString();
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public int getMaxTaskNum() {
        return this.maxTaskNum;
    }

    public void setMaxTaskNum(int maxTaskNum) {
        this.maxTaskNum = maxTaskNum;
    }

    public Integer getLiveNum() {
        return this.liveNum;
    }

    public void setLiveNum(Integer liveNum) {
        this.liveNum = liveNum;
    }

    class DefResult
    implements Result<Object> {
        private boolean isSuccess;

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public boolean isSuccess() {
            return this.isSuccess;
        }

        @Override
        public String errorCode() {
            return null;
        }

        @Override
        public String errorMessage() {
            return null;
        }

        public DefResult(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public DefResult() {
        }
    }

    class DefRunnable
    implements Callable<Result<?>> {
        private Runnable runnable;

        public DefRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public DefResult call() throws Exception {
            try {
                this.runnable.run();
                return new DefResult(true);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new DefResult(false);
            }
        }
    }
}

