/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.thread.pool.impl;

import com.irdstudio.bfp.executor.thread.Result;
import com.irdstudio.bfp.executor.thread.pool.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class DefaultJavaThreadPoolImpl
implements ThreadPool {
    private String threadPoolName = "DEFAULT";
    private int corePoolSize = 10;
    private int maxPoolSize = 20;
    private int queueSize = 50;
    private ExecutorService executorService;
    private BlockingQueue<Runnable> waitQueue;

    @Override
    public void start() {
        try {
            this.waitQueue = new LinkedBlockingQueue<Runnable>(this.queueSize);
            this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 200L, TimeUnit.MILLISECONDS, this.waitQueue, new ThreadPoolExecutor.AbortPolicy());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DefaultJavaThreadPoolImpl.class).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.destroy();
    }

    @Override
    public Future<Result<?>> add(Callable<Result<?>> task) throws Exception {
        this.assertExecutorService();
        return this.executorService.submit(task);
    }

    @Override
    public Collection<Future<Result<?>>> add(Collection<Callable<Result<?>>> tasks) throws Exception {
        this.assertExecutorService();
        if (Objects.nonNull(tasks)) {
            ArrayList results = new ArrayList(tasks.size());
            for (Callable<Result<?>> task : tasks) {
                results.add(this.executorService.submit(task));
            }
            return results;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (Objects.nonNull(this.executorService)) {
            this.executorService.shutdown();
            this.waitQueue.clear();
        }
    }

    @Override
    public int getCurrWaitTask() {
        return this.waitQueue.size();
    }

    @Override
    public String getTreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public boolean addRunnable(Runnable task) throws Exception {
        this.assertExecutorService();
        this.executorService.execute(task);
        return true;
    }

    @Override
    public boolean addRunnables(Collection<Runnable> tasks) throws Exception {
        this.assertExecutorService();
        if (Objects.nonNull(tasks)) {
            for (Runnable task : tasks) {
                this.executorService.execute(task);
            }
            return true;
        }
        return false;
    }

    public void assertExecutorService() throws Exception {
        if (Objects.isNull(this.executorService)) {
            throw new NullPointerException("\u7ebf\u7a0b\u6c60\u5c1a\u672a\u521d\u59cb\u5316!");
        }
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }
}

