/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dom4jXmlParseUtils {
    private static Logger logger = LoggerFactory.getLogger(Dom4jXmlParseUtils.class);

    public static Map<String, Object> parseXml(String xml) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
            Element rootElement = doc.getRootElement();
            Map<String, Object> rootMap = Dom4jXmlParseUtils.parseElement(rootElement);
            Iterator attrIterator = rootElement.attributeIterator();
            while (attrIterator.hasNext()) {
                Node node = (Node)attrIterator.next();
                rtnMap.put(node.getName(), node.getStringValue());
            }
            rtnMap.put(rootElement.getName(), rootMap);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rtnMap;
    }

    public static Map<String, Object> parseXmlNonService(String xml) {
        Map<String, Object> rtnMap = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
            Element rootElement = doc.getRootElement();
            rtnMap = Dom4jXmlParseUtils.parseElement(rootElement);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rtnMap;
    }

    private static Map<String, Object> parseElement(Element element) {
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (Objects.nonNull(e.elements()) && e.elements().size() > 0) {
                if ("array".equals(e.getName())) {
                    List<Map<String, Object>> list = Dom4jXmlParseUtils.parseArrayElement(e);
                    elementMap.put(((Element)e.elementIterator().next()).getName(), list);
                    continue;
                }
                Map<String, Object> eMap = Dom4jXmlParseUtils.parseElement(e);
                elementMap.put(e.getName(), eMap);
                continue;
            }
            elementMap.put(e.getName(), e.getTextTrim());
        }
        return elementMap;
    }

    private static List<Map<String, Object>> parseArrayElement(Element element) {
        Iterator iterator = element.elementIterator();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            Map<String, Object> eMap = Dom4jXmlParseUtils.parseElement(e);
            list.add(eMap);
        }
        return list;
    }

    public static String toXml(Map<String, Object> paramMap) {
        Document doc = DocumentHelper.createDocument();
        Element rootElement = DocumentHelper.createElement((String)"service");
        for (String key : paramMap.keySet()) {
            if (!(paramMap.get(key) instanceof String)) continue;
            rootElement.addAttribute(key, Dom4jXmlParseUtils.replaceNull(paramMap.get(key).toString()));
        }
        Dom4jXmlParseUtils.toXml((Map)paramMap.get("service"), rootElement);
        doc.add(rootElement);
        return doc.asXML();
    }

    public static String objectNonServiceToXml(Map<String, Object> paramMap) {
        Document doc = DocumentHelper.createDocument();
        Element rootElement = DocumentHelper.createElement((String)"service");
        rootElement.addAttribute("version", "2.0");
        Dom4jXmlParseUtils.toXml(paramMap, rootElement);
        doc.add(rootElement);
        return doc.asXML();
    }

    private static void toXml(Map<String, Object> paramMap, Element parentElement) {
        for (String key : paramMap.keySet()) {
            Element element;
            Object value = paramMap.get(key);
            if (value instanceof Map) {
                element = parentElement.addElement(key);
                Dom4jXmlParseUtils.toXml((Map)value, element);
                continue;
            }
            if (value instanceof Collection) {
                element = parentElement.addElement("array");
                Dom4jXmlParseUtils.toArrayXml((Collection)value, element, key);
                continue;
            }
            element = parentElement.addElement(key);
            element.setText(Dom4jXmlParseUtils.replaceNull(value));
        }
    }

    private static void toArrayXml(Collection paramColl, Element parentElement, String nodeName) {
        for (Object value : paramColl) {
            Element element;
            if (value instanceof Map) {
                element = parentElement.addElement(nodeName);
                Dom4jXmlParseUtils.toXml((Map)value, element);
                continue;
            }
            if (value instanceof Collection) {
                element = parentElement.addElement("array");
                Dom4jXmlParseUtils.toArrayXml((Collection)value, element, nodeName);
                continue;
            }
            element = parentElement.addElement(nodeName);
            element.setText(Dom4jXmlParseUtils.replaceNull(value));
        }
    }

    private static String replaceNull(Object obj) {
        return Objects.isNull(obj) ? "" : obj.toString();
    }
}

