/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtility {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtility.class);
    public static final ObjectMapper mapper = new ObjectMapper();

    private JacksonUtility() {
        throw new IllegalStateException("Utility class");
    }

    public static String serializeObjectToJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("serialize object to json", (Throwable)e);
            return null;
        }
    }

    public static void serializeObjectToFile(Object obj, File file) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(file, obj);
        }
        catch (Exception e) {
            logger.error("Serialize Object To Json", (Throwable)e);
        }
    }

    public static <T> T deserializeFormFile(File file, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(file, clazz);
        }
        catch (Exception e) {
            logger.error("Deserialize Json Form File", (Throwable)e);
            return null;
        }
    }

    public static <T> T deserializeJsonToObject(String json, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to Object", (Throwable)e);
            return null;
        }
    }

    public static <T> T deserializeJsonToObject(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to Object", (Throwable)e);
            return null;
        }
    }

    public static Object deserializeJsonToObject(String json, JavaType javaType) {
        try {
            return mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to Object", (Throwable)e);
            return null;
        }
    }

    public static <T> JavaType getListJavaType(Class<T> clazz) {
        TypeFactory typeFactory = mapper.getTypeFactory();
        return typeFactory.constructCollectionType(List.class, typeFactory.constructType(clazz));
    }

    public static <T> List<T> deserializeJsonToList(String json, Class<T> clazz) {
        JavaType javaType = JacksonUtility.getListJavaType(clazz);
        try {
            return (List)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to List", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static <K, V> JavaType getMapJavaType(Class<K> clazzKey, Class<V> clazzValue) {
        TypeFactory typeFactory = mapper.getTypeFactory();
        return typeFactory.constructMapType(Map.class, typeFactory.constructType(clazzKey), typeFactory.constructType(clazzValue));
    }

    public static <K, V> Map<K, V> deserializeJsonToMap(String json, Class<K> clazzKey, Class<V> clazzValue) {
        JavaType javaType = JacksonUtility.getMapJavaType(clazzKey, clazzValue);
        try {
            return (Map)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to Map", (Throwable)e);
            return null;
        }
    }

    public static <K, V> List<Map<K, V>> deserializeJsonToListMap(String json, Class<K> clazzKey, Class<V> clazzValue) {
        JavaType mapType = JacksonUtility.getMapJavaType(clazzKey, clazzValue);
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType javaType = typeFactory.constructCollectionType(List.class, mapType);
        try {
            return (List)mapper.readValue(json, (JavaType)javaType);
        }
        catch (Exception e) {
            logger.error("Deserialize Json to List<Map>", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static String hashMapToJson(Map<?, ?> map, Charset charset) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{");
        StringBuilder sBuilder = new StringBuilder();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            sBuilder.append("\"" + e.getKey() + "\":");
            sBuilder.append("\"" + e.getValue() + "\",");
        }
        String jsonString = sBuilder.substring(0, sBuilder.lastIndexOf(","));
        jsonBuilder.append(jsonString);
        jsonBuilder.append("}");
        byte[] body = jsonBuilder.toString().getBytes(charset);
        return new String(body, charset);
    }

    public static <T> List<T> getJosnToArray(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        List list = null;
        try {
            list = (List)mapper.readValue(jsonString, new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            logger.error("Deserialize Json to List", (Throwable)e);
        }
        return list;
    }
}

