/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.api.rest;

import com.irdstudio.bsp.console.service.facade.BatInstTaskService;
import com.irdstudio.bsp.console.service.facade.BatTaskUnitConfigService;
import com.irdstudio.bsp.console.service.vo.BatInstTaskTree;
import com.irdstudio.bsp.console.service.vo.BatInstTaskVO;
import com.irdstudio.bsp.console.service.vo.BatTaskUnitConfigVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BatInstTaskController
extends AbstractController {
    @Autowired
    @Qualifier(value="instTaskService")
    private BatInstTaskService batInstTaskService;
    @Autowired
    @Qualifier(value="taskConfigService")
    private BatTaskUnitConfigService batTaskUnitConfigService;

    @RequestMapping(value={"/bat/inst/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatInstTaskVO>> queryBatInstTaskAll(BatInstTaskVO vo) {
        List<BatInstTaskVO> outputVo = this.batInstTaskService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatInstTaskVO>> queryBpmBatInstTaskAll(BatInstTaskVO vo) {
        List<BatInstTaskVO> outputVo = this.batInstTaskService.queryBpmAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/bat/inst/tasks/his"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatInstTaskVO>> queryBpmBatInstTaskAllHis(BatInstTaskVO vo) {
        List<BatInstTaskVO> outputVo = this.batInstTaskService.queryBpmHisAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/{batchId}/{batchOrder}/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BatInstTaskVO> queryByPk(@PathVariable(value="batchId") String batchId, @PathVariable(value="batchOrder") String batchOrder, @PathVariable(value="taskId") String taskId) {
        BatInstTaskVO inVo = new BatInstTaskVO();
        inVo.setBatchId(batchId);
        inVo.setBatchOrder(Integer.valueOf(batchOrder));
        inVo.setTaskId(taskId);
        BatInstTaskVO outputVo = this.batInstTaskService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        int outputVo = this.batInstTaskService.deleteByPk(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        int outputVo = this.batInstTaskService.updateByPk(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBatInstTask(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        int outputVo = this.batInstTaskService.insertBatInstTask(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BatInstTaskTree> queryInstTaskTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        BatInstTaskVO inVo = new BatInstTaskVO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setBatchId(batchId);
        List<BatInstTaskTree> outputVo = this.batInstTaskService.queryBatInstTaskTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bpm/bat/inst/task/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BatInstTaskTree> queryBpmInstTaskTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        BatInstTaskVO inVo = new BatInstTaskVO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setBatchId(batchId);
        List<BatInstTaskTree> outputVo = this.batInstTaskService.queryBpmBatInstTaskTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bpm/bat/inst/task/his/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BatInstTaskTree> queryBpmInstTaskHisTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        BatInstTaskVO inVo = new BatInstTaskVO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setBatchId(batchId);
        List<BatInstTaskTree> outputVo = this.batInstTaskService.queryBpmBatInstTaskHisTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/bat/inst/task/hangup"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangUp(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        inBatInstTaskVo.setTaskInterveneState("2");
        int outputVo = this.batInstTaskService.updateTaskInterveneState(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/hangdown"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangDown(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        inBatInstTaskVo.setTaskInterveneState("0");
        int outputVo = this.batInstTaskService.updateTaskInterveneState(inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/inst/task/skip"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> skip(@RequestBody BatInstTaskVO inBatInstTaskVo) {
        BatTaskUnitConfigVO params = new BatTaskUnitConfigVO();
        params.setTaskId(inBatInstTaskVo.getTaskId());
        BatTaskUnitConfigVO configVO = this.batTaskUnitConfigService.queryByPk(params);
        ResponseData data = null;
        if (configVO != null && StringUtils.isNotEmpty((CharSequence)configVO.getTaskSkipTactic()) && !configVO.getTaskSkipTactic().equals("2")) {
            inBatInstTaskVo.setTaskInterveneState("1");
            int outputVo = this.batInstTaskService.updateTaskInterveneState(inBatInstTaskVo);
            data = this.getResponseData(outputVo);
        } else {
            data = this.getResponseData(-1);
            data.setMessage("\u8be5\u4efb\u52a1\u4e0d\u5141\u8bb8\u7f6e\u8fc7\uff01");
        }
        return data;
    }
}

