/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.api.rest;

import com.irdstudio.bsp.console.service.facade.BatBatchInfoConfigService;
import com.irdstudio.bsp.console.service.facade.SAgentInfoService;
import com.irdstudio.bsp.console.service.vo.BatBatchInfoConfigVO;
import com.irdstudio.bsp.console.service.vo.SAgentInfoVO;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.ssm.util.AgentApiUtil;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BatchLogController
extends AbstractController {
    @Autowired
    @Qualifier(value="batchConfigService")
    private BatBatchInfoConfigService batBatchInfoConfigService;
    @Autowired
    @Qualifier(value="sAgentInfoService")
    private SAgentInfoService sAgentInfoService;

    @RequestMapping(value={"/batch/logs/run/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getBatchRunLogs(@PathVariable(value="batchId") String batchId, @RequestParam(value="batchSerialNo") String batchSerialNo) {
        String output = "";
        try {
            BatBatchInfoConfigVO batBatchInfoConfigVO = new BatBatchInfoConfigVO();
            batBatchInfoConfigVO.setBatchId(batchId);
            batBatchInfoConfigVO = this.batBatchInfoConfigService.queryByPk(batBatchInfoConfigVO);
            if (Objects.isNull((Object)batBatchInfoConfigVO)) {
                throw new Exception("\u901a\u8fc7\u6279\u6b21\u53f7\u83b7\u53d6\u6279\u6b21\u4fe1\u606f\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6279\u6b21\u53f7\u4e3a:" + batchId);
            }
            String agentId = batBatchInfoConfigVO.getAgentId();
            SAgentInfoVO sAgentInfoVO = new SAgentInfoVO();
            sAgentInfoVO.setAgentId(agentId);
            sAgentInfoVO = this.sAgentInfoService.queryByPk(sAgentInfoVO);
            if (Objects.isNull((Object)sAgentInfoVO)) {
                throw new Exception("\u901a\u8fc7\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u83b7\u53d6\u4ee3\u7406\u8282\u70b9\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u4e3a:" + agentId);
            }
            String agentUrl = sAgentInfoVO.getAgentUrl();
            if (StringUtil.isNullorBank((String)agentUrl)) {
                throw new Exception("\u4ee3\u7406\u8282\u70b9\u5730\u5740\u4e3a\u7a7a\uff0c\u4ee3\u7406\u8282\u70b9\u6807\u8bc6\u4e3a:" + agentId);
            }
            output = AgentApiUtil.getBatchLogs((String)agentUrl, (String)batchId, (String)batchSerialNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            output = "\u83b7\u53d6\u6279\u6b21\u76d1\u63a7\u65e5\u5fd7\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
        }
        return output;
    }
}

