/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.bsp.console.dao.BpmBaseInfoDao;
import com.irdstudio.bsp.console.dao.BpmLinkedInfoDao;
import com.irdstudio.bsp.console.dao.BpmNodeInfoDao;
import com.irdstudio.bsp.console.dao.domain.BpmBaseInfo;
import com.irdstudio.bsp.console.dao.domain.BpmLinkedInfo;
import com.irdstudio.bsp.console.dao.domain.BpmNodeInfo;
import com.irdstudio.bsp.console.service.facade.BpmBaseInfoService;
import com.irdstudio.bsp.console.service.vo.BpmBaseInfoVO;
import com.irdstudio.bsp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmBaseInfoServiceImpl")
public class BpmBaseInfoServiceImpl
implements BpmBaseInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BpmBaseInfoServiceImpl.class);
    @Autowired
    private BpmBaseInfoDao bpmBaseInfoDao;
    @Autowired
    private BpmNodeInfoDao bpmNodeInfoDao;
    @Autowired
    private BpmLinkedInfoDao bpmLinkedInfoDao;

    @Override
    public int insertBpmBaseInfo(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpmBaseInfoVo.toString());
        int num = 0;
        try {
            inBpmBaseInfoVo.setBpmId(KeyUtil.createUUIDKey());
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            num = this.bpmBaseInfoDao.insertBpmBaseInfo(bpmBaseInfo);
            if (num > 0) {
                BpmNodeInfo startNode = new BpmNodeInfo();
                startNode.setBpmId(inBpmBaseInfoVo.getBpmId());
                startNode.setBpmNodeId(KeyUtil.createUUIDKey());
                startNode.setBpmNodeType("N01");
                startNode.setBpmNodeName("\u5f00\u59cb\u8282\u70b9");
                startNode.setH(35);
                startNode.setW(200);
                startNode.setX(215);
                startNode.setY(25);
                this.bpmNodeInfoDao.insertBpmNodeInfo(startNode);
                BpmNodeInfo endNode = new BpmNodeInfo();
                endNode.setBpmId(inBpmBaseInfoVo.getBpmId());
                endNode.setBpmNodeId(KeyUtil.createUUIDKey());
                endNode.setBpmNodeType("N99");
                endNode.setBpmNodeName("\u7ed3\u675f\u8282\u70b9");
                endNode.setH(35);
                endNode.setW(200);
                endNode.setX(215);
                endNode.setY(startNode.getY() + 100);
                this.bpmNodeInfoDao.insertBpmNodeInfo(endNode);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpmBaseInfoVo));
        int num = 0;
        try {
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            num = this.bpmBaseInfoDao.deleteByPk(bpmBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmBaseInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpmBaseInfoVo.toString());
        int num = 0;
        try {
            BpmBaseInfo bpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)bpmBaseInfo);
            num = this.bpmBaseInfoDao.updateByPk(bpmBaseInfo);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmBaseInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public BpmBaseInfoVO queryByPk(BpmBaseInfoVO inBpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBpmBaseInfoVo));
        try {
            BpmBaseInfo queryBpmBaseInfo = new BpmBaseInfo();
            this.beanCopy((Object)inBpmBaseInfoVo, (Object)queryBpmBaseInfo);
            BpmBaseInfo queryRslBpmBaseInfo = this.bpmBaseInfoDao.queryByPk(queryBpmBaseInfo);
            if (Objects.nonNull((Object)queryRslBpmBaseInfo)) {
                BpmBaseInfoVO outBpmBaseInfoVo = (BpmBaseInfoVO)((Object)this.beanCopy((Object)queryRslBpmBaseInfo, (Object)new BpmBaseInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBpmBaseInfoVo.toString());
                return outBpmBaseInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllOwner(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllOwnerByPage(bpmBaseInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllCurrOrg(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllCurrOrgByPage(bpmBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
        List list = null;
        try {
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Map<String, Object> queryBpmBaseInfoFlowData(String bpmId) {
        HashMap<String, Object> flowData = new HashMap<String, Object>();
        BpmBaseInfo queryBpmBaseInfo = new BpmBaseInfo();
        queryBpmBaseInfo.setBpmId(bpmId);
        try {
            BpmBaseInfo bpmBaseInfo = this.bpmBaseInfoDao.queryByPk(queryBpmBaseInfo);
            if (bpmBaseInfo != null) {
                BpmNodeInfoVO nodeParam = new BpmNodeInfoVO();
                nodeParam.setBpmId(bpmId);
                List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryBpmNodeInfoList(nodeParam);
                List<BpmLinkedInfo> bpmLinkeds = this.bpmLinkedInfoDao.queryBpmLinkedInfosByBpmId(bpmId);
                flowData.put(BpmBaseInfo.class.getSimpleName(), (Object)bpmBaseInfo);
                flowData.put(BpmNodeInfo.class.getSimpleName(), bpmNodeInfos);
                flowData.put(BpmLinkedInfo.class.getSimpleName(), bpmLinkeds);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d41\u7a0b\u914d\u7f6e\u5f02\u5e38\uff01{}", (Throwable)e);
            return null;
        }
        return flowData;
    }

    @Override
    public List<BpmBaseInfoVO> queryAllCurrDownOrg(BpmBaseInfoVO bpmBaseInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmBaseInfo> bpmBaseInfos = this.bpmBaseInfoDao.queryAllCurrDownOrgByPage(bpmBaseInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmBaseInfos.size());
        List list = null;
        try {
            this.pageSet(bpmBaseInfos, bpmBaseInfoVo);
            list = (List)this.beansCopy(bpmBaseInfos, BpmBaseInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Boolean saveBpmBaseInfoFlowData(Map<String, Object> flowData) {
        BaseInfo checkObj;
        List nodeInfos = (List)flowData.get(BpmNodeInfo.class.getSimpleName());
        List linkeds = (List)flowData.get(BpmLinkedInfo.class.getSimpleName());
        if (CollectionUtils.isNotEmpty((Collection)nodeInfos)) {
            List nodeList = JSON.parseArray((String)JSON.toJSONString((Object)nodeInfos), BpmNodeInfo.class);
            for (BpmNodeInfo node : nodeList) {
                try {
                    checkObj = this.bpmNodeInfoDao.queryByPk(node);
                    if (checkObj != null) {
                        this.bpmNodeInfoDao.updateByPk(node);
                        continue;
                    }
                    this.bpmNodeInfoDao.insertBpmNodeInfo(node);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)linkeds)) {
            List linkedList = JSON.parseArray((String)JSON.toJSONString((Object)linkeds), BpmLinkedInfo.class);
            for (BpmLinkedInfo linked : linkedList) {
                try {
                    checkObj = this.bpmLinkedInfoDao.queryByPk(linked);
                    if (checkObj != null) {
                        this.bpmLinkedInfoDao.updateByPk(linked);
                        continue;
                    }
                    this.bpmLinkedInfoDao.insertBpmLinkedInfo(linked);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return true;
    }
}

