/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.service.impl;

import com.irdstudio.bsp.console.dao.HomePageDao;
import com.irdstudio.bsp.console.dao.domain.HomePage;
import com.irdstudio.bsp.console.service.facade.HomePageService;
import com.irdstudio.bsp.console.service.vo.HomePageVO;
import com.irdstudio.bsp.console.service.vo.SSubsInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PageService")
public class HomePageServiceImpl
implements HomePageService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(HomePageServiceImpl.class);
    @Autowired
    private HomePageDao homePageDao;
    private final String CONSOLE_CODE = "console";

    @Override
    public List<HomePageVO> queryAll(List<String> list) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + list.toString());
        List homePageVOList = null;
        LinkedList<HomePage> homePages = new LinkedList<HomePage>();
        try {
            if (list != null) {
                for (String subsCode : list) {
                    HomePage homePage = this.homePageDao.queryAll(subsCode);
                    homePages.add(homePage);
                }
                logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + homePages.size());
                homePageVOList = (List)this.beansCopy(homePages, HomePageVO.class);
                System.out.println(homePageVOList);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return homePageVOList;
    }

    @Override
    public List<Map> querydmpconsoleAll(List<SSubsInfoVO> list) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + list.toString());
        ArrayList<Map> resultmap = new ArrayList<Map>();
        try {
            if (list.size() == 0) {
                return resultmap;
            }
            for (SSubsInfoVO item : list) {
                if ("console".equals(item.getSubsCode())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String subsName = item.getSubsName();
                String subsCode = item.getSubsCode();
                map.put("subsCode", subsCode);
                map.put("subsName", subsName);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("subsCode", subsCode);
                params.put("tableName", "migrate_table_info");
                params.put("opttype", "1");
                Integer source_table = this.homePageDao.querysourcetablecount(params);
                map.put("source_table", source_table);
                params.put("opttype", "3");
                Integer centre_table = this.homePageDao.querysourcetablecount(params);
                map.put("centre_table", centre_table);
                params.put("opttype", "2");
                Integer target_table = this.homePageDao.querysourcetablecount(params);
                map.put("target_table", target_table);
                params.remove("opttype");
                params.put("tableName", "migrate_check_rule");
                Integer migrate_check_rule = this.homePageDao.querysourcetablecount(params);
                map.put("migrate_check_rule", migrate_check_rule);
                params.put("tableName", "migrate_check_index");
                Integer migrate_check_index = this.homePageDao.querysourcetablecount(params);
                map.put("migrate_check_index", migrate_check_index);
                params.put("tableName", "bat_batch_info_config");
                Integer bat_batch_info_config = this.homePageDao.querysourcetablecount(params);
                map.put("bat_batch_info_config", bat_batch_info_config);
                params.put("tableName", "migrate_govern_task");
                Integer migrate_govern_task = this.homePageDao.querysourcetablecount(params);
                map.put("migrate_govern_task", migrate_govern_task);
                resultmap.add(map);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return resultmap;
    }
}

