/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.batch.dao;

import com.irdstudio.bsp.executor.core.batch.dao.BatBatchStageConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatBatchStageConfigDao {
    Connection conn = null;

    public BatBatchStageConfigDao(Connection conn) {
        this.conn = conn;
    }

    public BatBatchStageConfig queryWithKeys(String stageId, String batchId) throws SQLException {
        BatBatchStageConfig dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_batch_stage_config WHERE stage_id=? and batch_id=?");
            ps.setString(1, stageId);
            ps.setString(2, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatBatchStageConfig();
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchId(rs.getString("batch_id"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatBatchStageConfigWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatBatchStageConfig> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatBatchStageConfig> dcList = new ArrayList<BatBatchStageConfig>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_batch_stage_config " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatBatchStageConfig dc = new BatBatchStageConfig();
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchId(rs.getString("batch_id"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatBatchStageConfigWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

