/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.dao;

import com.irdstudio.bsp.executor.core.dao.domain.MigrateCheckIndex;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MigrateCheckIndexDao {
    Connection conn = null;

    public MigrateCheckIndexDao(Connection conn) {
        this.conn = conn;
    }

    public int insertMigrateCheckIndex(MigrateCheckIndex migrateCheckIndex) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into migrate_check_index ( check_index_id,subs_code,check_index_name,check_index_level,source_table_id,source_table_code,source_table_name,source_index_sql,target_table_id,target_table_code,target_table_name,target_index_sql) values (?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setObject(1, migrateCheckIndex.getCheckIndexId());
            ps.setObject(2, migrateCheckIndex.getSubsCode());
            ps.setObject(3, migrateCheckIndex.getCheckIndexName());
            ps.setObject(4, migrateCheckIndex.getCheckIndexLevel());
            ps.setObject(5, migrateCheckIndex.getSourceTableId());
            ps.setObject(6, migrateCheckIndex.getSourceTableCode());
            ps.setObject(7, migrateCheckIndex.getSourceTableName());
            ps.setObject(8, migrateCheckIndex.getSourceIndexSql());
            ps.setObject(9, migrateCheckIndex.getTargetTableId());
            ps.setObject(10, migrateCheckIndex.getTargetTableCode());
            ps.setObject(11, migrateCheckIndex.getTargetTableName());
            ps.setObject(12, migrateCheckIndex.getTargetIndexSql());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert MigrateCheckIndex is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(MigrateCheckIndex migrateCheckIndex) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from migrate_check_index where 1=1 AND check_index_id = ? ");
            ps.setObject(1, migrateCheckIndex.getCheckIndexId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete MigrateCheckIndex is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(MigrateCheckIndex migrateCheckIndex) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update migrate_check_index set  check_index_id = ? , subs_code = ? , check_index_name = ? , check_index_level = ? , source_table_id = ? , source_table_code = ? , source_table_name = ? , source_index_sql = ? , target_table_id = ? , target_table_code = ? , target_table_name = ? , target_index_sql = ?  where 1=1 AND check_index_id = ? ");
            ps.setObject(1, migrateCheckIndex.getCheckIndexId());
            ps.setObject(2, migrateCheckIndex.getSubsCode());
            ps.setObject(3, migrateCheckIndex.getCheckIndexName());
            ps.setObject(4, migrateCheckIndex.getCheckIndexLevel());
            ps.setObject(5, migrateCheckIndex.getSourceTableId());
            ps.setObject(6, migrateCheckIndex.getSourceTableCode());
            ps.setObject(7, migrateCheckIndex.getSourceTableName());
            ps.setObject(8, migrateCheckIndex.getSourceIndexSql());
            ps.setObject(9, migrateCheckIndex.getTargetTableId());
            ps.setObject(10, migrateCheckIndex.getTargetTableCode());
            ps.setObject(11, migrateCheckIndex.getTargetTableName());
            ps.setObject(12, migrateCheckIndex.getTargetIndexSql());
            ps.setObject(13, migrateCheckIndex.getCheckIndexId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update MigrateCheckIndex is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public MigrateCheckIndex queryByPk(MigrateCheckIndex migrateCheckIndex) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        MigrateCheckIndex result = null;
        try {
            ps = this.conn.prepareStatement("select check_index_id,subs_code,check_index_name,check_index_level,source_table_id,source_table_code,source_table_name,source_index_sql,target_table_id,target_table_code,target_table_name,target_index_sqlfrom migrate_check_index where 1=1  AND check_index_id = ? ");
            ps.setObject(1, migrateCheckIndex.getCheckIndexId());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new MigrateCheckIndex();
                result.setCheckIndexId(rs.getString("check_index_id"));
                result.setSubsCode(rs.getString("subs_code"));
                result.setCheckIndexName(rs.getString("check_index_name"));
                result.setCheckIndexLevel(rs.getString("check_index_level"));
                result.setSourceTableId(rs.getString("source_table_id"));
                result.setSourceTableCode(rs.getString("source_table_code"));
                result.setSourceTableName(rs.getString("source_table_name"));
                result.setSourceIndexSql(rs.getString("source_index_sql"));
                result.setTargetTableId(rs.getString("target_table_id"));
                result.setTargetTableCode(rs.getString("target_table_code"));
                result.setTargetTableName(rs.getString("target_table_name"));
                result.setTargetIndexSql(rs.getString("target_index_sql"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update MigrateCheckIndex is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<MigrateCheckIndex> queryAll(MigrateCheckIndex migrateCheckIndex) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<MigrateCheckIndex> result = new ArrayList<MigrateCheckIndex>();
        try {
            String sql = "select check_index_id,subs_code,check_index_name,check_index_level,source_table_id,source_table_code,source_table_name,source_index_sql,target_table_id,target_table_code,target_table_name,target_index_sqlfrom migrate_check_index where 1=1 ";
            if (migrateCheckIndex.getCheckIndexId() != null) {
                sql = sql + " AND check_index_id =  '" + migrateCheckIndex.getCheckIndexId() + "'";
            }
            if (migrateCheckIndex.getSubsCode() != null) {
                sql = sql + " AND subs_code =  '" + migrateCheckIndex.getSubsCode() + "'";
            }
            if (migrateCheckIndex.getCheckIndexName() != null) {
                sql = sql + " AND check_index_name =  '" + migrateCheckIndex.getCheckIndexName() + "'";
            }
            if (migrateCheckIndex.getCheckIndexLevel() != null) {
                sql = sql + " AND check_index_level =  '" + migrateCheckIndex.getCheckIndexLevel() + "'";
            }
            if (migrateCheckIndex.getSourceTableId() != null) {
                sql = sql + " AND source_table_id =  '" + migrateCheckIndex.getSourceTableId() + "'";
            }
            if (migrateCheckIndex.getSourceTableCode() != null) {
                sql = sql + " AND source_table_code =  '" + migrateCheckIndex.getSourceTableCode() + "'";
            }
            if (migrateCheckIndex.getSourceTableName() != null) {
                sql = sql + " AND source_table_name =  '" + migrateCheckIndex.getSourceTableName() + "'";
            }
            if (migrateCheckIndex.getSourceIndexSql() != null) {
                sql = sql + " AND source_index_sql =  '" + migrateCheckIndex.getSourceIndexSql() + "'";
            }
            if (migrateCheckIndex.getTargetTableId() != null) {
                sql = sql + " AND target_table_id =  '" + migrateCheckIndex.getTargetTableId() + "'";
            }
            if (migrateCheckIndex.getTargetTableCode() != null) {
                sql = sql + " AND target_table_code =  '" + migrateCheckIndex.getTargetTableCode() + "'";
            }
            if (migrateCheckIndex.getTargetTableName() != null) {
                sql = sql + " AND target_table_name =  '" + migrateCheckIndex.getTargetTableName() + "'";
            }
            if (migrateCheckIndex.getTargetIndexSql() != null) {
                sql = sql + " AND target_index_sql =  '" + migrateCheckIndex.getTargetIndexSql() + "'";
            }
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                MigrateCheckIndex obj = new MigrateCheckIndex();
                obj.setCheckIndexId(rs.getString("check_index_id"));
                obj.setSubsCode(rs.getString("subs_code"));
                obj.setCheckIndexName(rs.getString("check_index_name"));
                obj.setCheckIndexLevel(rs.getString("check_index_level"));
                obj.setSourceTableId(rs.getString("source_table_id"));
                obj.setSourceTableCode(rs.getString("source_table_code"));
                obj.setSourceTableName(rs.getString("source_table_name"));
                obj.setSourceIndexSql(rs.getString("source_index_sql"));
                obj.setTargetTableId(rs.getString("target_table_id"));
                obj.setTargetTableCode(rs.getString("target_table_code"));
                obj.setTargetTableName(rs.getString("target_table_name"));
                obj.setTargetIndexSql(rs.getString("target_index_sql"));
                result.add(obj);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update MigrateCheckIndex is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

