/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.dataload;

import com.irdstudio.bsp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bsp.executor.core.plugin.PluginLogService;
import com.irdstudio.bsp.executor.core.plugin.dataload.DataImportExecutor;
import com.irdstudio.bsp.executor.core.plugin.dataload.PluginLoadConf;
import com.irdstudio.bsp.executor.core.plugin.dataload.PluginLoadConfDao;
import com.irdstudio.bsp.executor.core.plugin.dataload.PluginLoadResult;
import com.irdstudio.bsp.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.bsp.executor.core.util.date.DateCalculate;
import com.irdstudio.bsp.executor.rest.utils.HexadecimalUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class TxtFileLoadPlugin
extends AbstractPlugin {
    private List<PluginLoadConf> loadList = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginLoadConfDao plcDao = new PluginLoadConfDao(conn);
        this.loadList = plcDao.queryWithPluginConfId(szConfIdentify);
        if (this.loadList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636e\u88c5\u8f7d\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.loadList.size(); ++i) {
            PluginLoadConf loadConf = this.loadList.get(i);
            loadConf.setTableName(this.context.toParseSysVariable(loadConf.getTableName()));
            loadConf.setLoadFromFile(this.context.toParseSysVariable(loadConf.getLoadFromFile()));
            loadConf.setBeforeLoadSql(this.context.toParseSysVariable(loadConf.getBeforeLoadSql()));
            loadConf.setAfterLoadSql(this.context.toParseSysVariable(loadConf.getAfterLoadSql()));
            loadConf.setLoadSeparator(HexadecimalUtil.dealHexadecimal(loadConf.getLoadSeparator()));
            this.logger.info("........................................................................");
            this.logger.info("\u51c6\u5907\u6267\u884c\u88c5\u8f7d\uff1a" + loadConf.getTableCnname() + "(" + loadConf.getTableName() + ")...");
            Connection conn = this.getPluginConnection();
            DataImportExecutor dataImport = new DataImportExecutor(loadConf, conn, this.logger);
            PluginLoadResult loadResult = dataImport.run();
            this.closePluginConnection(conn);
            loadResult.setEndTime(CurrentDateUtil.getTodayDateEx2());
            loadResult.setCostTime(DateCalculate.computeIntervalMills(loadResult.getStartTime(), loadResult.getEndTime()));
            loadResult.setBatchDate(this.context.getCurrentDataDate());
            loadResult.setBatchSerialNo(this.context.getSzBatchSn());
            loadResult.setBatchId(this.context.getSzBatchId());
            PluginLogService.getInstance().writeLoadResult(loadResult);
            if (!"3".equals(loadResult.getLoadResult())) {
                this.writeSuccessLog("\u6267\u884c\u6570\u636e\u88c5\u8f7d:" + loadConf.getTableCnname() + "(" + loadConf.getTableName() + ")");
                continue;
            }
            this.writeFaildLog("\u6267\u884c\u6570\u636e\u88c5\u8f7d:" + loadConf.getTableCnname() + "(" + loadConf.getTableName() + ")");
            if ("1".equals(loadConf.getLoadFaildDeal())) continue;
            flag = false;
            break;
        }
        return flag;
    }
}

