/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.util.pub;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SimpleDateUtil {
    public static final int SHANG_XUN = 1;
    public static final int ZHONG_XUN = 2;
    public static final int XIA_XUN = 3;
    private static String datePattern = "yyyy-MM-dd";
    private static int year;
    private static int month;
    private static int day;
    private static int season;
    private static int xun;

    private SimpleDateUtil() {
    }

    public static int getYear() {
        return year;
    }

    public static int getMonth() {
        return month;
    }

    public static int getDay() {
        return day;
    }

    public static int getSeason() {
        return season;
    }

    public static int getXun() {
        return xun;
    }

    public static String getDatePattern() {
        return datePattern;
    }

    public static void setDatePattern(String newDatePattern) {
        datePattern = newDatePattern;
    }

    private static int getSeason(int month) throws Exception {
        int itMonth = month;
        if (itMonth < 1 || itMonth > 12) {
            throw new Exception("getSeasonByMonth\u4f20\u5165\u7684\u6708\u4efd\u65e0\u6548:" + itMonth);
        }
        if (1 <= itMonth && itMonth <= 3) {
            return 1;
        }
        if (4 <= itMonth && itMonth <= 6) {
            return 2;
        }
        if (7 <= itMonth && itMonth <= 9) {
            return 3;
        }
        return 4;
    }

    private static int getXun(int day_of_month) throws Exception {
        if (day_of_month < 1 || day_of_month > 31) {
            throw new Exception("\u8f93\u5165\u7684\u5929\u6570\u6709\u8bef" + day_of_month);
        }
        if (day_of_month >= 1 && day_of_month <= 10) {
            return 1;
        }
        if (day_of_month > 10 && day_of_month <= 20) {
            return 2;
        }
        if (day_of_month > 20) {
            return 3;
        }
        return 0;
    }

    public static Calendar parse2Calendar(String str_date) throws Exception {
        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
        sf.setLenient(false);
        Date date = null;
        try {
            date = sf.parse(str_date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception("\u4f20\u5165\u7684\u65e5\u671f\u6709\u8bef\uff0c\u6216\u8005\u6ca1\u6709\u6b63\u786e\u8bbe\u7f6eformat\u683c\u5f0f", e);
        }
        Calendar tmpd = Calendar.getInstance();
        tmpd.setTime(date);
        return tmpd;
    }

    public static void getDateElements(String str_date) throws Exception {
        if (str_date == null || str_date.equals("")) {
            throw new Exception("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Calendar d = null;
        try {
            d = SimpleDateUtil.parse2Calendar(str_date);
        }
        catch (Exception e) {
            throw new Exception("\u65e5\u671f\u89e3\u6790\u51fa\u9519! \u65e5\u671f:" + str_date + " \u65e5\u671f\u683c\u5f0f:" + datePattern);
        }
        day = d.get(5);
        month = d.get(2) + 1;
        year = d.get(1);
        season = SimpleDateUtil.getSeason(month);
        xun = SimpleDateUtil.getXun(day);
    }

    public static void getDateElements(String str_date, String date_pattern) throws Exception {
        if (date_pattern == null || date_pattern.trim().equals("")) {
            throw new Exception("\u6a21\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateUtil.setDatePattern(date_pattern);
        SimpleDateUtil.getDateElements(str_date);
    }

    public static String getModifyDate(String str_date, int amount) throws Exception {
        Calendar d = SimpleDateUtil.parse2Calendar(str_date);
        d.add(5, amount);
        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
        sf.setLenient(false);
        return sf.format(d.getTime());
    }

    public static long diffDate(String date_begin, String date_end, String date_format) throws Exception {
        SimpleDateFormat sf = new SimpleDateFormat(date_format);
        sf.setLenient(false);
        Date d1 = sf.parse(date_begin);
        Date d2 = sf.parse(date_end);
        long beginTime = d1.getTime();
        long endTime = d2.getTime();
        long betweenDays = (endTime - beginTime) / 86400000L;
        return betweenDays;
    }

    public static long diffDate(String date_begin, String date_end, String date_begin_format, String date_end_format) throws Exception {
        SimpleDateFormat sf = new SimpleDateFormat(date_begin_format);
        SimpleDateFormat sf2 = new SimpleDateFormat(date_end_format);
        sf.setLenient(false);
        sf2.setLenient(false);
        Date d1 = sf.parse(date_begin);
        Date d2 = sf2.parse(date_end);
        long beginTime = d1.getTime();
        long endTime = d2.getTime();
        long betweenDays = (endTime - beginTime) / 86400000L;
        return betweenDays;
    }

    public static long diffDate(String date_begin, String date_end) throws Exception {
        return SimpleDateUtil.diffDate(date_begin, date_end, "yyyy-MM-dd");
    }

    public static long diffMonth(String dateBegin, String dateEnd, String dateFormat) {
        if (dateBegin == null || "".equals(dateBegin) || dateEnd == null || "".equals(dateEnd)) {
            return -1L;
        }
        Calendar begin = null;
        Calendar end = null;
        try {
            begin = SimpleDateUtil.parse2Calendar(dateBegin);
            end = SimpleDateUtil.parse2Calendar(dateEnd);
        }
        catch (Exception e) {
            return -1L;
        }
        int beginMonth = begin.get(2) + 1;
        int endMonth = end.get(2) + 1;
        int year = Math.abs(begin.get(1) - end.get(1));
        return Math.abs(year * 12 + (beginMonth - endMonth));
    }

    public static long diffMonth(String dateBegin, String dateEnd) {
        return SimpleDateUtil.diffMonth(dateBegin, dateEnd, datePattern);
    }

    public static String formatDate(String date, String strFormat) {
        String strRet = null;
        SimpleDateFormat sdf = new SimpleDateFormat(strFormat, Locale.ENGLISH);
        try {
            strRet = sdf.format(sdf.parse(date));
            return strRet;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public static String formatDate(Date date, String strFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(strFormat, Locale.ENGLISH);
        return sdf.format(date);
    }

    public static int getMonthLastDay(int nf, int yf) {
        StringBuffer theDate = new StringBuffer();
        theDate.append(nf);
        theDate.append("-");
        theDate.append(yf);
        theDate.append("-");
        theDate.append("01");
        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
        Date date = null;
        try {
            date = sf.parse(theDate.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(6, -1);
        return calendar.get(5);
    }

    public static String getMonthLastDayStr(int nf, int yf) {
        StringBuffer theDate = new StringBuffer();
        theDate.append(nf);
        theDate.append("-");
        theDate.append(yf);
        theDate.append("-");
        theDate.append("01");
        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
        Date date = null;
        try {
            date = sf.parse(theDate.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.add(6, -1);
        return SimpleDateUtil.formatDate(calendar.getTime(), "yyyy-MM-dd");
    }

    public static String addYearMonthDay(String date, String nyr) {
        int day;
        int month;
        int year;
        Date date1 = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date1 = sf.parse(date);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("\u89e3\u6790\u65e5\u671f[" + date + "]\u51fa\u9519");
        }
        try {
            year = Integer.parseInt(nyr.substring(0, 2));
            month = Integer.parseInt(nyr.substring(2, 4));
            day = Integer.parseInt(nyr.substring(4, 6));
        }
        catch (RuntimeException e) {
            System.err.println("\u8ba1\u7b97\u5e74\u6708\u65e5\u9519\u8bef:" + nyr);
            throw e;
        }
        int y = date1.getYear();
        int m = date1.getMonth();
        int d = date1.getDate();
        return sf.format(new Date(y + year, m + month, d + day));
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        String xtrq = sdf.format(new Date());
        System.out.println(xtrq);
        System.out.println(SimpleDateUtil.addYearMonthDay(xtrq, "010101"));
        SimpleDateUtil.getDateElements("2003-01-12");
        System.out.println("\u5e74\u4efd\uff1a" + SimpleDateUtil.getYear());
        System.out.println("\u6708\u4efd\uff1a" + SimpleDateUtil.getMonth());
        System.out.println("\u65e5\u671f\uff1a" + SimpleDateUtil.getDay());
        System.out.println("\u5b63\u5ea6\uff1a" + SimpleDateUtil.getSeason());
        System.out.println("\u65ec:" + SimpleDateUtil.getXun());
        System.out.println("\u83b7\u5f97\u76f8\u5bf9\u65e5\u671f\uff1a" + SimpleDateUtil.getModifyDate("2010-12-1", -12));
        System.out.println(SimpleDateUtil.diffMonth("2003-05-12", "2005-05-25"));
        System.out.println(SimpleDateUtil.diffMonth("2006-05-12", "2006-06-01"));
        System.out.println(SimpleDateUtil.diffMonth("2006-05-12", "2006-04-01"));
        System.out.println(SimpleDateUtil.diffMonth("2005-05-12", "2004-08-01"));
    }
}

