/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.rest.utils;

import com.irdstudio.bsp.executor.rest.job.BatchStarter;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class ClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(BatchStarter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                boolean fieldAccessible = field.isAccessible();
                if (!fieldAccessible) {
                    field.setAccessible(true);
                }
                Unsafe unsafe = null;
                try {
                    unsafe = (Unsafe)field.get(null);
                }
                catch (Exception exception) {
                }
                finally {
                    field.setAccessible(fieldAccessible);
                }
                if (Objects.isNull(unsafe)) {
                    return null;
                }
                Field ucpField = classLoader.getClass().getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList path = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                return path.toArray(new URL[path.size()]);
            }
            catch (Exception e) {
                logger.error("getUrls\u65b9\u6cd5\u6267\u884c\u5931\u8d25", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

