/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.batch.dao;

import com.irdstudio.bsp.executor.core.batch.dao.BatBatchInfoConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatBatchInfoConfigDao {
    Connection conn = null;

    public BatBatchInfoConfigDao(Connection conn) {
        this.conn = conn;
    }

    public BatBatchInfoConfig queryWithKeys(String batchId) throws SQLException {
        BatBatchInfoConfig dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_batch_info_config WHERE batch_id=?");
            ps.setString(1, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatBatchInfoConfig();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setLaunchType(rs.getString("launch_type"));
                dc.setBatchCronValue(rs.getString("batch_cron_value"));
                dc.setAgentId(rs.getString("agent_id"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setEquallyTaskAmount(rs.getInt("equally_task_amount"));
                dc.setIsRunAgain(rs.getString("is_run_again"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatBatchInfoConfigWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatBatchInfoConfig> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatBatchInfoConfig> dcList = new ArrayList<BatBatchInfoConfig>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM BAT_BATCH_INFO_CONFIG " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatBatchInfoConfig dc = new BatBatchInfoConfig();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setLaunchType(rs.getString("launch_type"));
                dc.setBatchCronValue(rs.getString("batch_cron_value"));
                dc.setAgentId(rs.getString("agent_id"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setEquallyTaskAmount(rs.getInt("equally_task_amount"));
                dc.setIsRunAgain(rs.getString("is_run_again"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatBatchInfoConfigWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

