/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.fileop;

import com.irdstudio.bsp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bsp.executor.core.plugin.fileop.PluginFileopConf;
import com.irdstudio.bsp.executor.core.plugin.fileop.PluginFileopConfDao;
import com.irdstudio.bsp.executor.core.util.date.DateCalculate;
import com.irdstudio.bsp.executor.core.util.date.DateConvert;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class FileOpPlugin
extends AbstractPlugin {
    private List<PluginFileopConf> pfocList;
    private String fileOpDesc = "";
    private String fileOpTarget = "";
    private static String FILE_OP_EXIST = "01";
    private static String FILE_OP_COMPRESS = "02";
    private static String FILE_OP_REMOVE = "03";
    private static String FILE_OP_ENCRYPT = "04";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginFileopConfDao confDao = new PluginFileopConfDao(conn);
        this.pfocList = confDao.queryWithPluginConfId(szConfIdentify);
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.pfocList.size(); ++i) {
            PluginFileopConf pfoc = this.pfocList.get(i);
            this.context.getVv().addVariable("fileop.target_date", DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(pfoc.getLastOpDate()), pfoc.getDistanceDay())));
            this.context.getVv().addVariable("fileop.target_date_8", this.context.getVv().getValue("fileop.target_date").replaceAll("-", ""));
            boolean bResult = false;
            this.fileOpTarget = this.context.toParseSysVariable(pfoc.getFileTarget()).replace('\\', '/');
            if (this.fileOpTarget.endsWith("/")) {
                this.fileOpTarget = this.fileOpTarget.substring(0, this.fileOpTarget.length() - 1);
            }
            if (FILE_OP_EXIST.equals(pfoc.getFileOp())) {
                this.fileOpDesc = "\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728";
                bResult = this.isFileExist();
            } else if (FILE_OP_COMPRESS.equals(pfoc.getFileOp())) {
                this.fileOpDesc = "\u6587\u4ef6/\u76ee\u5f55\u538b\u7f29";
                bResult = this.doCompressFile(pfoc);
            } else if (FILE_OP_REMOVE.equals(pfoc.getFileOp())) {
                this.fileOpDesc = "\u6587\u4ef6/\u76ee\u5f55\u5220\u9664";
                bResult = this.doDeleteFile(pfoc);
            } else if (FILE_OP_ENCRYPT.equals(pfoc.getFileOp())) {
                this.fileOpDesc = "\u6587\u4ef6/\u76ee\u5f55\u52a0\u5bc6";
                bResult = this.doEncryptFile(pfoc);
            }
            if (bResult) {
                this.writeSuccessLog("\u6267\u884c" + this.fileOpDesc + ":" + this.fileOpTarget);
                String sql = "update plugin_fileop_conf set last_op_date='" + this.context.getCurrentDataDate() + "' where plugin_conf_id='" + pfoc.getPluginConfId() + "' and conf_sort=" + pfoc.getConfSort();
                if (this.executeSql(sql)) continue;
                flag = false;
                this.writeFaildLog("\u66f4\u65b0\u4e0a\u6b21\u64cd\u4f5c\u65e5\u671f");
                continue;
            }
            flag = false;
            this.writeFaildLog("\u6267\u884c" + this.fileOpDesc + ":" + this.fileOpTarget);
        }
        return flag;
    }

    private boolean isFileExist() {
        if (this.initFileParam()) {
            File file = new File(this.fileOpTarget);
            return file.exists();
        }
        return false;
    }

    private boolean initFileParam() {
        if (this.fileOpTarget == null || "".equals(this.fileOpTarget)) {
            this.context.setSzLastErrorMsg(this.fileOpTarget);
            this.writeFaildLog("\u64cd\u4f5c\u76ee\u6807\u4e3a\u7a7a\u503c,\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c!...");
            return false;
        }
        this.logger.info("........................................................................");
        this.logger.info("\u51c6\u5907\u8fdb\u884c" + this.fileOpDesc + "\uff1a" + this.fileOpTarget + "...");
        return true;
    }

    private boolean doCompressFile(PluginFileopConf pfoc) {
        if (!this.initFileParam()) {
            return false;
        }
        if (!this.isArrivedNextOpDate(pfoc)) {
            return true;
        }
        return true;
    }

    private boolean doEncryptFile(PluginFileopConf pfoc) {
        if (!this.initFileParam()) {
            return false;
        }
        if (!this.isArrivedNextOpDate(pfoc)) {
            return true;
        }
        return true;
    }

    private boolean doDeleteFile(PluginFileopConf pfoc) {
        if (!this.initFileParam()) {
            return false;
        }
        if (!this.isArrivedNextOpDate(pfoc)) {
            return true;
        }
        File file = new File(this.fileOpTarget);
        return file.delete();
    }

    private boolean isArrivedNextOpDate(PluginFileopConf pfoc) {
        boolean bFlag = false;
        if (pfoc.getLastOpDate() == null || "".equals(pfoc.getLastOpDate())) {
            pfoc.setLastOpDate(this.context.getCurrentDataDate());
        }
        String nextOpDate = DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(pfoc.getLastOpDate()), pfoc.getOpCycleDay()));
        if (this.context.getCurrentDataDate().compareTo(nextOpDate) >= 0) {
            bFlag = true;
        }
        return bFlag;
    }
}

