/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.migrate.dao;

import com.irdstudio.bsp.executor.core.plugin.migrate.dao.MigrateCheckRule;
import com.irdstudio.bsp.executor.core.plugin.migrate.dao.MigrationtabledataUtilDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MigrateCheckRuleDao {
    Connection conn = null;
    MigrationtabledataUtilDao utildao = null;

    public MigrateCheckRuleDao(Connection conn) {
        this.conn = conn;
        this.utildao = new MigrationtabledataUtilDao(conn);
    }

    public List<MigrateCheckRule> queryMigrateCheckRuleWithAll() throws SQLException {
        ArrayList<MigrateCheckRule> dcList = new ArrayList<MigrateCheckRule>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        MigrateCheckRule dc = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM migrate_check_rule");
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new MigrateCheckRule();
                dc.setCheckRuleId(rs.getString("check_rule_id"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setCheckRuleName(rs.getString("check_rule_name"));
                dc.setTableId(rs.getString("table_id"));
                dc.setTableCode(rs.getString("table_code"));
                dc.setTableName(rs.getString("table_name"));
                dc.setCheckRuleSql(rs.getString("check_rule_sql"));
                dc.setCheckExpectValue(rs.getBigDecimal("check_expect_value"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryMigrateCheckRuleWithAll is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public List<MigrateCheckRule> queryMigrateCheckRuleWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<MigrateCheckRule> dcList = new ArrayList<MigrateCheckRule>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM migrate_check_rule " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                MigrateCheckRule dc = new MigrateCheckRule();
                dc.setCheckRuleId(rs.getString("check_rule_id"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setCheckRuleName(rs.getString("check_rule_name"));
                dc.setTableId(rs.getString("table_id"));
                dc.setTableCode(rs.getString("table_code"));
                dc.setTableName(rs.getString("table_name"));
                dc.setCheckRuleSql(rs.getString("check_rule_sql"));
                dc.setCheckExpectValue(rs.getBigDecimal("check_expect_value"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryMigrateCheckRuleWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public boolean delete(String checkRuleId) throws SQLException {
        String delsql = " delete from migrate_rule_result where check_rule_id='" + checkRuleId + "'";
        return this.utildao.addorupdateordeltable(delsql);
    }

    public List<Map> selectTableList(MigrateCheckRule rule) throws SQLException {
        return this.utildao.selecttablelist(rule.getCheckRuleSql());
    }

    public boolean insertTable(MigrateCheckRule rule, String rsql, int resultcount, String check_expect_flag) throws SQLException {
        String sql = " insert into migrate_rule_result (check_result_id,check_rule_id, subs_code, check_rule_name, table_id, table_code, table_name, check_rule_sql, check_expect_value, check_result_value, check_expect_flag) VALUES (replace(uuid(), '-', ''),'" + rule.getCheckRuleId() + "','" + rule.getSubsCode() + "','" + rule.getCheckRuleName() + "','" + rule.getTableId() + "','" + rule.getTableCode() + "','" + rule.getTableName() + "','" + rsql + "','" + rule.getCheckExpectValue() + "','" + resultcount + "','" + check_expect_flag + "')";
        return this.utildao.addorupdateordeltable(sql);
    }

    public List<Map> selectGovern(String checkRuleId) throws SQLException {
        String selectGovernSql = " select * from migrate_govern_task where  govern_src_id='" + checkRuleId + "'";
        return this.utildao.selecttablelist(selectGovernSql);
    }

    public boolean addOrUpdateOrDeleteTable(MigrateCheckRule rule) throws SQLException {
        String addGovernSql = " insert into batch_migrate.migrate_govern_task (govern_task_id,govern_src_id, govern_task_src, govern_task_desc, impact_analysis, migrate_comment, dev_comment, test_comment, tech_comment, busi_comment, source_incharge, target_incharge, govern_task_state, task_begin_date, task_require_finish_date, task_real_finish_date,subs_code) VALUES ((select IFNULL(b.govern_task_id,00000) from (select LPAD(max(CAST(govern_task_id as SIGNED))+1, 5, 0) as govern_task_id  from migrate_govern_task) b),'" + rule.getCheckRuleId() + "' ,'R', '" + rule.getCheckRuleName() + "', '', '', '', '', '', '', '', '', '0', '', '', '','" + rule.getSubsCode() + "')";
        return this.utildao.addorupdateordeltable(addGovernSql);
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

