/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.rest.schedule;

import com.irdstudio.bsp.executor.core.dao.SSrvsCronConfDao;
import com.irdstudio.bsp.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.bsp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bsp.executor.rest.init.ExecutorInstInfo;
import com.irdstudio.bsp.executor.rest.schedule.QuartzJobEngine;
import com.irdstudio.bsp.executor.rest.schedule.QuartzManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class ScheduleJobUtil {
    public static final String STATE_WAIT = "S";
    public static final String STATE_ARRANGED = "A";
    public static final String STATE_RUNNING = "R";
    public static final String STATE_FALSE = "F";
    private static Logger logger = Logger.getLogger(ScheduleJobUtil.class);
    public static String JOB_GROUP_NAME = "AGENT_JOB_GROUP";
    public static String TRIGGER_NAME = "AGENT_TRIGGER";
    public static String TRIGGER_GROUP_NAME = "AGENT_TRIGGER_GROUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJobsForExecutor() {
        logger.info((Object)"\u5f00\u59cb\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            SSrvsCronConfDao sSrvsCronConfDao = new SSrvsCronConfDao(conn);
            List<SSrvsCronConf> cronConfList = sSrvsCronConfDao.queryByAgentId(ExecutorInstInfo.EXECUTOR_ID);
            for (SSrvsCronConf cronConf : cronConfList) {
                if (cronConf.getJobState().equals(STATE_WAIT)) {
                    cronConf.setJobState(STATE_ARRANGED);
                    sSrvsCronConfDao.updateByPk(cronConf);
                }
                logger.info((Object)("\u52a0\u5165\u5b9a\u65f6\u4efb\u52a1\uff1a" + cronConf.getJobDesc() + "..."));
                QuartzManager.addJob(cronConf.getJobCode(), JOB_GROUP_NAME, TRIGGER_NAME + "-" + cronConf.getJobCode(), TRIGGER_GROUP_NAME, QuartzJobEngine.class, cronConf.getCronExpression());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
        logger.info((Object)"\u52a0\u8f7dAgent\u6240\u9700\u8981\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }

    public static void stopJobsForAgent() {
        logger.info((Object)"\u5f00\u59cb\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1...");
        try {
            QuartzManager.shutdownJobs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info((Object)"\u505c\u6b62Agent\u6240\u6267\u884c\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f!");
    }
}

