/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.assembly.jxp.func;

import com.irdstudio.bsp.executor.core.assembly.jxp.conf.DefineSection;
import com.irdstudio.bsp.executor.core.assembly.jxp.util.LogUtil;
import com.irdstudio.bsp.executor.core.util.pub.Convert;
import com.irdstudio.bsp.executor.core.util.pub.SimpleDateUtil;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxpFunc {
    private static final Logger logger = LoggerFactory.getLogger(JxpFunc.class);
    private DefineSection define = null;
    private static final Map<String, String> funLib = new Hashtable<String, String>();

    public JxpFunc(DefineSection define) {
        this.define = define;
    }

    public String callJxpFunc(String funcName, String param) {
        String result = "";
        Method doMethod = null;
        Class<?> thisClass = this.getClass();
        Class[] parameterTypes = new Class[]{String.class};
        Object[] arguments = new Object[]{param};
        try {
            doMethod = thisClass.getMethod(funcName.toLowerCase(), parameterTypes);
            result = (String)doMethod.invoke((Object)this, arguments);
        }
        catch (NoSuchMethodException e) {
            LogUtil.out("\u4e0d\u652f\u6301[" + funcName + "]\u51fd\u6570!");
        }
        catch (Exception e) {
            LogUtil.out(e.getMessage());
        }
        return result;
    }

    public String tran(String param) {
        Hashtable value;
        String[] params = this.splitParam(param);
        if (params.length < 3) {
            LogUtil.out("Error:\u5185\u7f6e\u51fd\u6570\u8c03\u7528\u9519\u8bef!");
            LogUtil.out("Usage:tran(<param1>,<param2>,[param2])");
        }
        if ((value = (Hashtable)this.define.getDefine(params[1])) == null || value.get(params[0]) == null) {
            if (params.length == 3) {
                return params[2];
            }
            return "not found";
        }
        return (String)value.get(params[0]);
    }

    public String concat(String param) {
        String[] params = this.splitParam(param);
        String result = "";
        for (int i = 0; i < params.length; ++i) {
            result = result.concat(params[i]);
        }
        return result;
    }

    public String sum(String param) {
        long result = 0L;
        String[] params = this.splitParam(param);
        for (int i = 0; i < params.length; ++i) {
            result += (long)Convert.StrToInt(params[i], 0);
        }
        return new Long(result).toString();
    }

    public String getvalue(String param) {
        return param;
    }

    public String dateformat(String param) {
        String[] params = this.splitParam(param);
        if (params.length != 2) {
            LogUtil.out("Usage:dateformat(datestr,format)");
            return "param error";
        }
        if ("".equals(params[0].trim())) {
            return "";
        }
        if ("yyyymmdd".equals(params[1].toLowerCase())) {
            StringBuffer date = new StringBuffer();
            try {
                SimpleDateUtil.getDateElements(params[0]);
                date.append(SimpleDateUtil.getYear());
                if (SimpleDateUtil.getMonth() < 10) {
                    date.append('0');
                }
                date.append(SimpleDateUtil.getMonth());
                if (SimpleDateUtil.getDay() < 10) {
                    date.append('0');
                }
                date.append(SimpleDateUtil.getDay());
            }
            catch (Exception e) {
                LogUtil.out(e.getMessage());
            }
            return date.toString();
        }
        return SimpleDateUtil.formatDate(params[0], params[1]);
    }

    public String floatformat(String param) {
        StringBuffer result = new StringBuffer();
        String[] params = this.splitParam(param);
        if (params.length != 2) {
            LogUtil.out("Usage:floatformat(float,format)");
            return "param error";
        }
        if (params[0] == null || "".equals(params[0].trim())) {
            result.append('0');
        } else {
            result.append(params[0]);
        }
        int digitIndex = result.indexOf(".");
        int digitLength = Convert.StrToInt(params[1], 0);
        String zs = "";
        String xs = "";
        if (digitIndex > 0) {
            zs = result.substring(0, digitIndex);
            xs = result.substring(digitIndex + 1);
        } else {
            zs = result.toString();
        }
        for (int i = 0; i < digitLength; ++i) {
            xs = xs + "0";
        }
        if (digitLength > 0) {
            result.delete(0, result.length());
            result.append(zs);
            result.append('.');
            result.append(xs.substring(0, digitLength));
        } else {
            result.delete(0, result.length());
            result.append(zs);
        }
        return result.toString();
    }

    public String substring(String param) {
        String[] params = this.splitParam(param);
        if (params.length < 2) {
            LogUtil.out("Usage:substring(<str>,<begin>,[end])");
            return "param error";
        }
        int begin = Convert.StrToInt(params[1], 0);
        int end = 0;
        if (params.length == 3) {
            end = Convert.StrToInt(params[2], 0);
        }
        if (params[0] == null || "".equals(params[0])) {
            return "";
        }
        if (end == 0 || params[0].length() < end) {
            return params[0].substring(begin);
        }
        return params[0].substring(begin, end);
    }

    public String datediff(String param) {
        long result = 0L;
        String[] params = this.splitParam(param);
        if (params.length < 2) {
            LogUtil.out("Usage:datediff(d1,[...])");
            return "param error";
        }
        if (params[0] == null || "".equals(params[0])) {
            return new Long(result).toString();
        }
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == null || "".equals(params[i])) continue;
            try {
                result = SimpleDateUtil.diffDate(params[0], params[i]);
            }
            catch (Exception e) {
                LogUtil.out(e.getMessage());
            }
            if (result > 0L) break;
        }
        result = result < 0L ? 0L : result;
        return new Long(result).toString();
    }

    public String getyqts(String param) {
        long result = 0L;
        String[] params = this.splitParam(param);
        if (params.length < 3) {
            LogUtil.out("Usage:getyqtx(nf,yf,date");
            return "param error";
        }
        if (params[0] == null || "".equals(params[0])) {
            new Long(result).toString();
        }
        String fljzrq = this.getmonthlastday(params[0] + "," + params[1]);
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        sf.setLenient(false);
        Date date = null;
        try {
            date = sf.parse(fljzrq);
            fljzrq = SimpleDateUtil.formatDate(date, "yyyy-MM-dd");
        }
        catch (ParseException e) {
            LogUtil.out("\u65e5\u671f\u89e3\u91ca\u9519\u8bef!" + e.getMessage());
        }
        return this.datediff(params[2].trim() + "," + fljzrq);
    }

    public String getmonthlastday(String param) {
        String result = "";
        String[] params = this.splitParam(param);
        if (params.length != 2) {
            LogUtil.out("Usage:getMonthLastDay(<nf,yf>)");
            return "param error";
        }
        int nf = Convert.StrToInt(params[0], 2006);
        int yf = Convert.StrToInt(params[1], 1);
        result = SimpleDateUtil.getMonthLastDayStr(nf, yf);
        return result;
    }

    private String[] splitParam(String param) {
        if (param.charAt(param.length() - 1) == ',') {
            param = param.concat(" ");
        }
        return param.split(",");
    }

    public boolean isExists() {
        return true;
    }

    public static void main(String[] args) {
        JxpFunc func = new JxpFunc(null);
        System.err.println(func.callJxpFunc("getyqts", "2006,09,2006-01-01"));
    }

    static {
        funLib.put("tran", "2");
        funLib.put("getValue", "1");
        funLib.put("sum", "-1");
        funLib.put("concat", "-1");
        funLib.put("DateFormat", "2");
        funLib.put("substring", "3");
        funLib.put("FloatFormat", "3");
        funLib.put("DateDiff", "-1");
    }
}

