/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.dao;

import com.irdstudio.bsp.executor.core.dao.BatBatchStageConfigDao;
import com.irdstudio.bsp.executor.core.dao.domain.BatBatchStageConfig;
import com.irdstudio.bsp.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.bsp.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.bsp.executor.core.util.date.DateCalculate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatInstBatchDao {
    Connection conn = null;

    public BatInstBatchDao(Connection conn) {
        this.conn = conn;
    }

    public BatInstBatch queryWithKeys(String batchId) throws SQLException {
        BatInstBatch dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch WHERE batch_id=?");
            ps.setString(1, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatInstBatch();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setBatchState(rs.getString("batch_state"));
                dc.setBatchInterveneState(rs.getString("batch_intervene_state"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setNeedRunCount(rs.getInt("need_run_count"));
                dc.setExistRunCount(rs.getInt("exist_run_count"));
                dc.setNotRunCount(rs.getInt("not_run_count"));
                dc.setSucceedRunCount(rs.getInt("succeed_run_count"));
                dc.setFaildRunCount(rs.getInt("faild_run_count"));
                dc.setWarnRunCount(rs.getInt("warn_run_count"));
                dc.setSkipRunCount(rs.getInt("skip_run_count"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatInstBatch> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatInstBatch> dcList = new ArrayList<BatInstBatch>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstBatch dc = new BatInstBatch();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setBatchState(rs.getString("batch_state"));
                dc.setBatchInterveneState(rs.getString("batch_intervene_state"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setNeedRunCount(rs.getInt("need_run_count"));
                dc.setExistRunCount(rs.getInt("exist_run_count"));
                dc.setNotRunCount(rs.getInt("not_run_count"));
                dc.setSucceedRunCount(rs.getInt("succeed_run_count"));
                dc.setFaildRunCount(rs.getInt("faild_run_count"));
                dc.setWarnRunCount(rs.getInt("warn_run_count"));
                dc.setSkipRunCount(rs.getInt("skip_run_count"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateStage(BatInstBatch batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            BatBatchStageConfigDao stageDao = new BatBatchStageConfigDao(this.conn);
            BatBatchStageConfig stageInfo = stageDao.queryWithKeys(batchInst.getStageId(), batchInst.getBatchId());
            ps = this.conn.prepareStatement("update bat_inst_batch set batch_state=?,stage_id=?,stage_name=? where batch_id=?");
            ps.setString(1, String.valueOf(3));
            ps.setString(2, batchInst.getStageId());
            ps.setString(3, stageInfo.getStageName());
            ps.setString(4, batchInst.getBatchId());
            ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
    }

    public void updateBatchToEnd(BatInstBatch batchInst) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update bat_inst_batch set batch_state=?,end_time=?,cost_time=?,remark=? where batch_id=?");
            String endTime = CurrentDateUtil.getTodayDateEx2();
            ps.setString(1, batchInst.getBatchState());
            ps.setString(2, endTime);
            ps.setBigDecimal(3, DateCalculate.computeIntervalMills(batchInst.getStartTime(), endTime));
            ps.setString(4, batchInst.getRemark());
            ps.setString(5, batchInst.getBatchId());
            ps.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO bat_inst_batch_h SELECT * FROM bat_inst_batch WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM bat_inst_batch WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }
}

