/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.dao;

import com.irdstudio.bsp.executor.core.dao.domain.BatInstBatchH;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatInstBatchHDao {
    Connection conn = null;

    public BatInstBatchHDao(Connection conn) {
        this.conn = conn;
    }

    public BatInstBatchH queryWithKeys(String batchSerialNo) throws SQLException {
        BatInstBatchH dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch_h WHERE batch_serial_no=?");
            ps.setString(1, batchSerialNo);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatInstBatchH();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setBatchState(rs.getString("batch_state"));
                dc.setBatchInterveneState(rs.getString("batch_intervene_state"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setNeedRunCount(rs.getInt("need_run_count"));
                dc.setExistRunCount(rs.getInt("exist_run_count"));
                dc.setNotRunCount(rs.getInt("not_run_count"));
                dc.setSucceedRunCount(rs.getInt("succeed_run_count"));
                dc.setFaildRunCount(rs.getInt("faild_run_count"));
                dc.setWarnRunCount(rs.getInt("warn_run_count"));
                dc.setSkipRunCount(rs.getInt("skip_run_count"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchHWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatInstBatchH> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatInstBatchH> dcList = new ArrayList<BatInstBatchH>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_batch_h " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstBatchH dc = new BatInstBatchH();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setBatchName(rs.getString("batch_name"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setBatchState(rs.getString("batch_state"));
                dc.setBatchInterveneState(rs.getString("batch_intervene_state"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setNeedRunCount(rs.getInt("need_run_count"));
                dc.setExistRunCount(rs.getInt("exist_run_count"));
                dc.setNotRunCount(rs.getInt("not_run_count"));
                dc.setSucceedRunCount(rs.getInt("succeed_run_count"));
                dc.setFaildRunCount(rs.getInt("faild_run_count"));
                dc.setWarnRunCount(rs.getInt("warn_run_count"));
                dc.setSkipRunCount(rs.getInt("skip_run_count"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstBatchHWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

