/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.dao;

import com.irdstudio.bsp.executor.core.dao.domain.BatInstTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatInstTaskDao {
    Connection conn = null;

    public BatInstTaskDao(Connection conn) {
        this.conn = conn;
    }

    public BatInstTask queryWithKeys(String batchId, int batchOrder, String taskId) throws SQLException {
        BatInstTask dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_task WHERE batch_id=? and batch_order=? and task_id=?");
            ps.setString(1, batchId);
            ps.setInt(2, batchOrder);
            ps.setString(3, taskId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new BatInstTask();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstTaskWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<BatInstTask> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<BatInstTask> dcList = new ArrayList<BatInstTask>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM bat_inst_task " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                BatInstTask dc = new BatInstTask();
                dc.setBatchId(rs.getString("batch_id"));
                dc.setBatchOrder(rs.getInt("batch_order"));
                dc.setTaskId(rs.getString("task_id"));
                dc.setBatchDate(rs.getString("batch_date"));
                dc.setTaskName(rs.getString("task_name"));
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setTaskRunState(rs.getString("task_run_state"));
                dc.setTaskInterveneState(rs.getString("task_intervene_state"));
                dc.setStartTime(rs.getString("start_time"));
                dc.setEndTime(rs.getString("end_time"));
                dc.setCostTime(rs.getBigDecimal("cost_time"));
                dc.setWarnCount(rs.getInt("warn_count"));
                dc.setOther(rs.getString("other"));
                dc.setBatchSerialNo(rs.getString("batch_serial_no"));
                dc.setStateDesc(rs.getString("state_desc"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryBatInstTaskWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    public boolean updateBatInstTask(String szCondition) throws SQLException {
        PreparedStatement ps = null;
        boolean executeResult = false;
        try {
            ps = this.conn.prepareStatement("update bat_inst_task " + szCondition);
            executeResult = ps.execute();
            this.close(null, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("updateBatInstTask is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(null, null, ps);
                throw throwable;
            }
        }
        return executeResult;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void resetFaildTask(String batchId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement("update bat_inst_task set task_run_state=?,start_time='',end_time='',cost_time=0 where batch_id=? and task_run_state='7'");
            ps.setString(1, String.valueOf(1));
            ps.setString(2, batchId);
            ps.execute();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.close(null, null, ps);
        }
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO bat_inst_task_h SELECT * FROM bat_inst_task WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM bat_inst_task WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }
}

