/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.dataexport;

import com.irdstudio.bsp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bsp.executor.core.plugin.DaoUtil;
import com.irdstudio.bsp.executor.core.plugin.FileHandleUtil;
import com.irdstudio.bsp.executor.core.plugin.dataexport.DataExportCallable;
import com.irdstudio.bsp.executor.core.plugin.dataexport.PluginExportConf;
import com.irdstudio.bsp.executor.core.plugin.dataexport.PluginExportConfDao;
import com.irdstudio.bsp.executor.core.plugin.util.PluginUtil;
import com.irdstudio.bsp.executor.core.util.pub.PathUtil;
import com.irdstudio.bsp.executor.rest.utils.HexadecimalUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.beanutils.BeanUtils;

public class ExportTxtFilePlugin
extends AbstractPlugin {
    private List<PluginExportConf> exportList = null;
    private int records = 1000000;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginExportConfDao pecDao = new PluginExportConfDao(conn);
        this.exportList = pecDao.queryWithPluginConfId(szConfIdentify);
        if (this.exportList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636e\u5bfc\u51fa\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        OutputStreamWriter fos = null;
        for (int i = 0; i < this.exportList.size(); ++i) {
            PluginExportConf exportConf = this.exportList.get(i);
            exportConf.setExportTarget(this.context.toParseSysVariable(exportConf.getExportTarget()));
            exportConf.setExportToFile(this.context.toParseSysVariable(exportConf.getExportToFile()));
            exportConf.setOkFileFullName(this.context.toParseSysVariable(exportConf.getOkFileFullName()));
            exportConf.setOkFileContent(this.context.toParseSysVariable(exportConf.getOkFileContent()));
            exportConf.setFieldSeparator(HexadecimalUtil.dealHexadecimal(exportConf.getFieldSeparator()));
            this.logger.info("........................................................................");
            this.logger.info("\u51c6\u5907\u5bfc\u51fa\u6570\u636e\uff1a\u4ece\"" + exportConf.getExportTarget() + "\"\u5230\"" + exportConf.getExportToFile() + "\"...");
            Connection conn = this.getPluginConnection();
            try {
                int total = 0;
                String exportMode = exportConf.getExportMode();
                String exportTarget = exportConf.getExportTarget();
                String totalSql = "select COUNT(*) as total from ";
                totalSql = "01".equals(exportMode) ? totalSql + exportTarget : totalSql + "(" + exportTarget + ") t";
                Map<String, String> totalMap = DaoUtil.getFirstRecord(totalSql, null, conn);
                total = Integer.parseInt(totalMap.get("total") == null ? "0" : totalMap.get("total"));
                int threadCount = PluginUtil.getThreadAmount(this.records, total);
                ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
                ExecutorService threadPoll = null;
                List<PluginExportConf> pecList = null;
                if (threadCount > 0) {
                    this.logger.info("......\u542f\u52a8\u7ebf\u7a0b[" + threadCount + "\u6761]\u5b8c\u6210\u63d2\u4ef6[" + exportConf.getPluginConfId() + "]\u5bfc\u6570\u4efb\u52a1......");
                    threadPoll = Executors.newFixedThreadPool(threadCount);
                    pecList = this.threadPluginExportConf(exportConf, threadCount);
                    for (PluginExportConf pluginExportConf : pecList) {
                        futureList.add(threadPoll.submit(new DataExportCallable(pluginExportConf, this.getPluginConnection(), this.logger)));
                    }
                }
                if (futureList.size() > 0) {
                    for (Future future : futureList) {
                        if (((Boolean)future.get()).booleanValue()) continue;
                        throw new Exception("\u6267\u884c[" + exportConf.getPluginConfId() + "]\u7ebf\u7a0b\u5904\u7406\u5f02\u5e38\uff01");
                    }
                    if (threadPoll != null) {
                        threadPoll.shutdown();
                    }
                }
                if (total == 0) {
                    String localFileName = exportConf.getExportToFile();
                    String string = (localFileName = localFileName.replace('\\', '/')).substring(0, localFileName.lastIndexOf("/"));
                    if (!new File(string).isDirectory()) {
                        PathUtil.checkAndCreate(string);
                        if (!new File(string).isDirectory()) {
                            this.logger.info("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + string + "]\u5931\u8d25");
                            throw new Exception("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + string + "]\u5931\u8d25");
                        }
                    }
                    fos = new FileWriter(exportConf.getExportToFile());
                    fos.close();
                }
                this.logger.info("\u63d2\u4ef6[" + exportConf.getPluginConfId() + "],\u591a\u7ebf\u7a0b[" + threadCount + "]\u6267\u884c\u5b8c\u6210\uff0c\u8fdb\u884c\u6587\u4ef6\u5408\u5e76\u64cd\u4f5c..........");
                long mergeStart = System.currentTimeMillis();
                boolean fileFlag = this.getSplitFilePaths(pecList);
                this.logger.info("\u63d2\u4ef6[" + exportConf.getPluginConfId() + "],\u6587\u4ef6\u5408\u5e76\u7ed3\u675f[" + fileFlag + "]\uff0c\u7528\u65f6[" + (System.currentTimeMillis() - mergeStart) / 1000L + "]\u79d2..........");
                String okFileContent = "";
                if ("Y".equals(exportConf.getIsOkFile())) {
                    fos = new FileWriter(exportConf.getOkFileFullName());
                    okFileContent = exportConf.getOkFileContent() == null ? "" : exportConf.getOkFileContent().replace("{count}", String.valueOf(total));
                    fos.write(okFileContent);
                    fos.close();
                    this.logger.info("\u63d2\u4ef6[" + exportConf.getPluginConfId() + "],\u751f\u6210OK\u6587\u4ef6[" + exportConf.getOkFileFullName() + "]\u7ed3\u675f\u3002");
                }
                this.logger.info("\u63d2\u4ef6[" + exportConf.getPluginConfId() + "],\u5bfc\u51fa\u8bb0\u5f55\u603b\u6570:" + total);
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u51fa\u9519", e);
                flag = false;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5173\u95ed\u8d44\u6e90\u51fa\u9519", e);
                    }
                }
            }
            this.closePluginConnection(conn);
        }
        return flag;
    }

    public List<PluginExportConf> threadPluginExportConf(PluginExportConf pec, int threadCount) throws CloneNotSupportedException, IllegalAccessException, InvocationTargetException {
        ArrayList<PluginExportConf> pecList = new ArrayList<PluginExportConf>();
        int satrt = 0;
        int end = this.records;
        for (int i = 1; i <= threadCount; ++i) {
            PluginExportConf pluginExportConf = new PluginExportConf();
            BeanUtils.copyProperties((Object)pluginExportConf, (Object)pec);
            if (i != 1) {
                pluginExportConf.setExportToFile(pec.getExportToFile() + ".split" + i);
            }
            String pageSql = " LIMIT " + satrt + "," + end + ";";
            if ("01".equals(pec.getExportMode())) {
                pluginExportConf.setExportMode("02");
                pluginExportConf.setExportTarget("SELECT * FROM " + pec.getExportTarget() + pageSql);
            } else {
                pluginExportConf.setExportTarget(pec.getExportTarget().replace(";", " ") + pageSql);
            }
            pecList.add(pluginExportConf);
            satrt = end * i;
        }
        return pecList;
    }

    public boolean getSplitFilePaths(List<PluginExportConf> pecList) throws Exception {
        ArrayList<String> fileInPtahs = new ArrayList<String>();
        String fileOutPath = "";
        if (pecList != null) {
            if (pecList.size() == 1) {
                return true;
            }
            fileOutPath = pecList.get(0).getExportToFile();
            for (int i = 1; i < pecList.size(); ++i) {
                fileInPtahs.add(pecList.get(i).getExportToFile());
            }
        }
        boolean flag = true;
        try {
            flag = FileHandleUtil.mergedFiles(fileInPtahs, fileOutPath);
        }
        catch (Exception e) {
            flag = false;
            throw new Exception(e);
        }
        return flag;
    }
}

