/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.datajob;

import com.irdstudio.bsp.executor.core.plugin.AbstractPlugin;
import com.irdstudio.bsp.executor.core.plugin.datajob.PluginJobConf;
import com.irdstudio.bsp.executor.core.plugin.datajob.PluginJobConfDao;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractDataJobPlugin
extends AbstractPlugin {
    protected List<PluginJobConf> dsList;
    protected static String SQL_PURPOSE_NO = "1";
    protected static String SQL_PURPOSE_BEFORE = "2";
    protected static String SQL_PURPOSE_JOB = "3";
    protected static String SQL_PURPOSE_AFTER = "4";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginJobConfDao jobDao = new PluginJobConfDao(conn);
        this.dsList = jobDao.queryWithPluginConfId(szConfIdentify);
        if (this.dsList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636e\u4f5c\u4e1a\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.dsList.size(); ++i) {
            boolean bResult;
            PluginJobConf jobConf = this.dsList.get(i);
            this.logger.info("........................................................................");
            this.logger.info("\u51c6\u5907\u8c03\u7528\u4f5c\u4e1a\uff1a" + jobConf.getJobName() + "...");
            if (!SQL_PURPOSE_NO.equals(jobConf.getSqlPurpose()) && SQL_PURPOSE_BEFORE.equals(jobConf.getSqlPurpose())) {
                flag = this.customDeal(jobConf);
            }
            if (bResult = this.doExecuteJob(jobConf)) {
                this.writeSuccessLog("\u6267\u884c\u4f5c\u4e1a:" + jobConf.getJobName());
                if (!SQL_PURPOSE_AFTER.equals(jobConf.getSqlPurpose())) continue;
                flag = this.customDeal(jobConf);
                continue;
            }
            this.writeFaildLog("\u6267\u884c\u4f5c\u4e1a:" + jobConf.getJobName());
            if ("1".equals(jobConf.getJobFaildDeal())) {
                if (!SQL_PURPOSE_AFTER.equals(jobConf.getSqlPurpose())) continue;
                flag = this.customDeal(jobConf);
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    public abstract boolean doExecuteJob(PluginJobConf var1);

    private boolean customDeal(PluginJobConf jobConf) {
        this.logger.info("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e\u7684SQL\u811a\u672c...");
        boolean flag = true;
        String[] conds = jobConf.getSqlContent().split(";");
        for (int i = 0; i < conds.length; ++i) {
            String sql = this.context.toParseSysVariable(conds[i]);
            boolean subFlag = this.executeSql(sql);
            if (subFlag) {
                this.writeSuccessLog("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e\u7684SQL\u811a\u672c", sql);
                continue;
            }
            this.writeFaildLog("\u6267\u884c\u4f5c\u4e1a\u914d\u7f6e\u7684SQL\u811a\u672c", sql + "," + this.context.getSzLastErrorMsg());
            flag = subFlag;
        }
        return flag;
    }
}

