/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.core.plugin.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.irdstudio.bsp.executor.rest.utils.PropertiesUtil;
import com.irdstudio.bsp.executor.rest.utils.SpringContextUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class DubboClient {
    private static Logger logger = Logger.getLogger(DubboClient.class);
    private Map<String, ReferenceConfig<GenericService>> referenceConfigMapping = new ConcurrentHashMap<String, ReferenceConfig<GenericService>>();
    private Object lock = new Object();
    private String protocol = PropertiesUtil.getApplicationKey("dubbo.registry.protocol");
    private String address = PropertiesUtil.getApplicationKey("dubbo.registry.address");
    private String cluster = PropertiesUtil.getApplicationKey("dubbo.consumer.cluster");
    private String retries = PropertiesUtil.getApplicationKey("dubbo.consumer.retries");
    private String timeout = PropertiesUtil.getApplicationKey("dubbo.consumer.timeout");
    private String applicationName = PropertiesUtil.getApplicationKey("spring.application.name");

    public GenericService buildGenericService(String serviceInterface, String group, String version) {
        return this.buildGenericService(serviceInterface, Integer.valueOf(this.timeout), group, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericService buildGenericService(String serviceInterface, int timeout, String group, String version) {
        ReferenceConfig reference = this.referenceConfigMapping.get(serviceInterface);
        if (reference == null || reference.get() == null) {
            Object object = this.lock;
            synchronized (object) {
                reference = this.referenceConfigMapping.get(serviceInterface);
                if (reference == null || reference.get() == null) {
                    reference = new ReferenceConfig();
                    RegistryConfig registry = new RegistryConfig();
                    registry.setProtocol(this.protocol);
                    registry.setAddress(this.address);
                    registry.setFile(this.applicationName + ".properties");
                    reference.setApplication(new ApplicationConfig(this.applicationName));
                    reference.setRegistry(registry);
                    reference.setInterface(serviceInterface);
                    reference.setGeneric(Boolean.valueOf(true));
                    reference.setSent(Boolean.valueOf(false));
                    reference.setCluster(this.cluster);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{group})) {
                        reference.setGroup(group);
                    }
                    reference.setRetries(Integer.valueOf(this.retries));
                    reference.setTimeout(Integer.valueOf(timeout));
                    reference.setVersion(StringUtils.isEmpty((CharSequence)version) ? "1.0.0" : version);
                    this.referenceConfigMapping.put(serviceInterface, (ReferenceConfig<GenericService>)reference);
                }
            }
        }
        logger.info((Object)"\u83b7\u53d6\u670d\u52a1\u6210\u529f\uff01");
        return (GenericService)reference.get();
    }

    public static DubboClient getDubboClient() {
        return (DubboClient)SpringContextUtils.getBean("dubboClient");
    }
}

