/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.rest.utils;

import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextUtils
implements ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        context = ctx;
    }

    public static Object getBean(String beanId) {
        SpringContextUtils.assertContext();
        return context.getBean(beanId);
    }

    public static <T> T getBean(String beanId, Class<T> clazz) {
        SpringContextUtils.assertContext();
        return (T)context.getBean(beanId, clazz);
    }

    public static void assertContext() {
        if (Objects.isNull(context)) {
            throw new NullPointerException();
        }
    }

    public static <T> T getBean(Class<T> type) {
        SpringContextUtils.assertContext();
        return (T)context.getBean(type);
    }
}

