/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.common.constant.dxm.reqbuilder;

import com.alibaba.fastjson.annotation.JSONField;
import com.irdstudio.efp.esb.common.constant.dxm.DxmEnum;
import com.irdstudio.efp.esb.common.constant.dxm.reqbuilder.DXMBasicInfo;
import com.irdstudio.efp.esb.common.constant.dxm.reqbuilder.DXMMessage;
import java.util.Objects;

public class DXMReqBodyBuilder {
    public static Builder ReqBuilder() {
        return new Builder();
    }

    public static class Builder {
        @JSONField(name="ProdCd")
        private String ProdCd;
        @JSONField(name="TxnMd")
        private String TxnMd;
        @JSONField(name="RepeatRqsBss")
        private String RepeatRqsBss;
        @JSONField(name="Message")
        private DXMMessage Message = new DXMMessage();

        public Builder buildSyncRequest() {
            this.setTxnMd(DxmEnum.TxnModel.SYNC.getValue());
            return this;
        }

        public Builder buildAsyncRequest() {
            this.setTxnMd(DxmEnum.TxnModel.ASYNC.getValue());
            return this;
        }

        public Builder buildProdCd(String prodCd) {
            this.ProdCd = Objects.requireNonNull(prodCd, "prodCd\u4ea7\u54c1\u4ee3\u7801\u4e0d\u4e3a\u7a7a\uff01");
            return this;
        }

        public Builder buildRepeatRqsBss(String repeatRqsBss) {
            this.RepeatRqsBss = Objects.requireNonNull(repeatRqsBss, "BdReqSn_\u91cd\u590d\u8bf7\u6c42\u4f9d\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return this;
        }

        public Builder buildMessageNecessityInfo(String sessionId, String evID) {
            Objects.requireNonNull(sessionId, "\u4f1a\u8bddID_\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Objects.requireNonNull(evID, "bdTransationId_\u4e8b\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.Message.setSessionId(sessionId);
            this.Message.setEvID(evID);
            this.Message.setRqsTmstmp(String.valueOf(System.currentTimeMillis()));
            return this;
        }

        public Builder buildMeaageEvTypeOfApply() {
            this.Message.setEvTp(DxmEnum.EVTYPE.EVTYPE_APPLY.getValue());
            return this;
        }

        public Builder buildMessageEvTypeOfTransaction() {
            this.Message.setEvTp(DxmEnum.EVTYPE.EVTYPE_TRANSACTION.getValue());
            return this;
        }

        public Builder buildMessageEvTypeOfQuery() {
            this.Message.setEvTp(DxmEnum.EVTYPE.EVTYPE_QUERY.getValue());
            return this;
        }

        public Builder buildMessageBasicInfo(DXMBasicInfo DXMBasicInfo2) {
            Objects.requireNonNull(DXMBasicInfo2, "basicInfo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.Message.setDXMBasicInfo(DXMBasicInfo2);
            return this;
        }

        public Builder builderExpanding(Object object) {
            Objects.requireNonNull(object, "\u6269\u5c55\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            this.Message.setExpanding(object);
            return this;
        }

        public Builder build() {
            return this;
        }

        public String getTxnMd() {
            return this.TxnMd;
        }

        public void setTxnMd(String txnMd) {
            this.TxnMd = txnMd;
        }

        public String getProdCd() {
            return this.ProdCd;
        }

        public void setProdCd(String prodCd) {
            this.ProdCd = prodCd;
        }

        public String getRepeatRqsBss() {
            return this.RepeatRqsBss;
        }

        public void setRepeatRqsBss(String repeatRqsBss) {
            this.RepeatRqsBss = repeatRqsBss;
        }

        public DXMMessage getMessage() {
            return this.Message;
        }

        public void setMessage(DXMMessage message) {
            this.Message = message;
        }
    }
}

