/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLogUtil {
    private static Logger logger = LoggerFactory.getLogger(JsonLogUtil.class);
    public static final int MIN_LENGTH = 10;
    public static final int MAX_LENGTH = 50;
    public static final int DIV = 3;
    public static final String BODY_KEY = "BODY";

    public static String hideMsg(String msg) throws Exception {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return "";
        }
        if (msg.length() < 10) {
            return msg;
        }
        int num = msg.length() / 3;
        num = num > 50 ? 50 : num;
        return StringUtils.left((String)msg, (int)num).concat("***").concat(StringUtils.right((String)msg, (int)num));
    }

    public static String changeJSONStrWithBody(String jsonStr, String key) {
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return jsonStr;
            }
            if (jsonStr.indexOf(key) >= 0) {
                JSONObject jsonJo = JSONObject.parseObject((String)jsonStr);
                JSONObject bodyJo = jsonJo.getJSONObject(BODY_KEY);
                if (Objects.isNull(bodyJo)) {
                    return jsonStr;
                }
                String keyVal = bodyJo.getString(key);
                keyVal = JsonLogUtil.hideMsg(keyVal);
                bodyJo.put(key, (Object)keyVal);
                jsonJo.put(BODY_KEY, (Object)bodyJo);
                return JSONObject.toJSONString((Object)jsonJo);
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u4fe1\u606f\u8f93\u51fa\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f" + e.getMessage());
            e.printStackTrace();
        }
        return jsonStr;
    }

    public static String changeJSONStr(String jsonStr, String key) {
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return jsonStr;
            }
            if (jsonStr.indexOf(key) >= 0) {
                JSONObject jsonJo = JSONObject.parseObject((String)jsonStr);
                String keyVal = jsonJo.getString(key);
                keyVal = JsonLogUtil.hideMsg(keyVal);
                jsonJo.put(key, (Object)keyVal);
                return JSONObject.toJSONString((Object)jsonJo);
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u4fe1\u606f\u8f93\u51fa\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f" + e.getMessage());
            e.printStackTrace();
        }
        return jsonStr;
    }
}

