/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("{} \u5f02\u5e38", (Object)((Object)((Object)e)).getClass().getName(), (Object)e);
            return null;
        }
    }

    public static Object fromJson(String string, TypeReference typeReference) {
        try {
            return objectMapper.readValue(string, typeReference);
        }
        catch (Exception e) {
            log.error("{} \u5f02\u5e38", (Object)e.getClass().getName(), (Object)e);
            return null;
        }
    }

    public static <T> Optional<T> fromJson(String string, Class<T> classType) {
        try {
            return Optional.of(objectMapper.readValue(string, classType));
        }
        catch (Exception e) {
            log.error("{} \u5f02\u5e38", (Object)e.getClass().getName(), (Object)e);
            return null;
        }
    }
}

