/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.boot;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.container.Container;
import com.alibaba.fastjson.util.TypeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DubboServiceMainMock {
    private static volatile boolean running = true;
    private static final Logger logger = LogManager.getLogger(DubboServiceMainMock.class);
    private static final String APPLICATION_CONTEXT_PATH = "classpath*:spring/applicationContext.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("dubbo.spring.config", APPLICATION_CONTEXT_PATH);
        TypeUtils.compatibleWithJavaBean = true;
        long startTime = System.currentTimeMillis();
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Container.class);
        try {
            String config = ConfigUtils.getProperty((String)"dubbo.container", (String)loader.getDefaultExtensionName());
            String[] containerNames = Constants.COMMA_SPLIT_PATTERN.split(config);
            final ArrayList<Object> containers = new ArrayList<Object>();
            for (int i = 0; i < containerNames.length; ++i) {
                containers.add(loader.getExtension(containerNames[i]));
            }
            logger.debug("Dubbo  stopped!");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Iterator iterator = containers.iterator();
                    while (iterator.hasNext()) {
                        Container container = (Container)iterator.next();
                        try {
                            container.stop();
                            logger.debug("Dubbo " + container.getClass().getSimpleName() + " stopped!");
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                        }
                        Class<DubboServiceMainMock> clazz = DubboServiceMainMock.class;
                        // MONITORENTER : com.irdstudio.efp.esb.service.boot.DubboServiceMainMock.class
                        running = false;
                        DubboServiceMainMock.class.notify();
                        // MONITOREXIT : clazz
                    }
                }
            });
            for (Container container : containers) {
                container.start();
                logger.info("Dubbo " + container.getClass().getSimpleName() + " started!");
            }
            long elasticsTime = System.currentTimeMillis() - startTime;
            String startedMsg = "efp-esb-mock started, elapsedTime=" + (double)elasticsTime / 1000.0 + "s";
            logger.info(startedMsg);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        Class<DubboServiceMainMock> clazz = DubboServiceMainMock.class;
        synchronized (DubboServiceMainMock.class) {
            while (running) {
                try {
                    DubboServiceMainMock.class.wait();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

