/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client;

import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import com.irdstudio.efp.esb.service.client.ESBConfig;
import com.irdstudio.efp.esb.service.client.HttpClientFactory;
import com.irdstudio.efp.esb.service.client.SimpleHttpClientFactory;
import com.irdstudio.efp.esb.service.client.impl.DefaultESBBeanCreator;
import com.irdstudio.efp.esb.service.client.impl.DefaultESBConfig;
import com.irdstudio.efp.esb.service.client.impl.ESBClient;
import com.irdstudio.efp.esb.service.client.impl.ESBClientImpl;
import java.util.Objects;

public class ESBClientFactory {
    public static Builder buildClient() {
        return new Builder();
    }

    private ESBClientFactory() {
        throw new IllegalAccessError();
    }

    public static class Builder {
        private Object bodyBean;
        private String tradeNo;
        private String scene;
        private String msgTp;
        private ESBConfig config = (ESBConfig)SpringContextUtils.getBean(DefaultESBConfig.class);
        private HttpClientFactory factory = SimpleHttpClientFactory.newInstance(this.config.getTimeout());
        private ESBBeanCreator esbBeanCreator = DefaultESBBeanCreator.getINSTANCE();

        public Builder withBody(Object object) {
            this.bodyBean = Objects.requireNonNull(object);
            return this;
        }

        public Builder withTradeNo(String tradeNo) {
            this.tradeNo = Objects.requireNonNull(tradeNo);
            return this;
        }

        public Builder withMsgTp(String msgTp) {
            this.msgTp = Objects.requireNonNull(msgTp);
            return this;
        }

        public Builder withScene(String scene) {
            this.scene = Objects.requireNonNull(scene);
            return this;
        }

        public Builder withConfig(ESBConfig config) {
            this.config = Objects.requireNonNull(config);
            return this;
        }

        public Builder withHttpClientFactory(HttpClientFactory factory) {
            this.factory = Objects.requireNonNull(factory);
            return this;
        }

        public Builder withESBBeanFactory(ESBBeanCreator esbBeanCreator) {
            this.esbBeanCreator = Objects.requireNonNull(esbBeanCreator);
            return this;
        }

        public ESBClient create() {
            return new ESBClientImpl(this);
        }

        public Object getToSend() {
            return this.bodyBean;
        }

        public String getTradeNo() {
            return this.tradeNo;
        }

        public String getScene() {
            return this.scene;
        }

        public ESBConfig getConfig() {
            return this.config;
        }

        public ESBBeanCreator getESBBeanFactory() {
            return this.esbBeanCreator;
        }

        public HttpClientFactory getFactory() {
            return this.factory;
        }

        public String getMsgTp() {
            return this.msgTp;
        }
    }
}

