/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client;

import com.irdstudio.efp.esb.service.client.HttpClientFactory;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class SimpleHttpClientFactory
implements HttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpClientFactory.class);
    private RestTemplate restTemplate;

    public static SimpleHttpClientFactory newInstance(int timeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        RestTemplate temp = new RestTemplate();
        List messageConverters = temp.getMessageConverters();
        messageConverters = messageConverters.stream().filter(i -> !StringHttpMessageConverter.class.isInstance(i)).collect(Collectors.toList());
        messageConverters.add(new StringHttpMessageConverter(Charset.forName("utf-8")));
        temp.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        temp.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        SimpleHttpClientFactory factory = new SimpleHttpClientFactory();
        factory.setClient(temp);
        log.info("SimpleHttpClient\u521d\u59cb\u5316\u5b8c\u6210");
        return factory;
    }

    @Override
    public RestTemplate getClient() {
        return Objects.requireNonNull(this.restTemplate);
    }

    public void setClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private SimpleHttpClientFactory() {
    }
}

