/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.client.impl;

import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.req.EsbReqAppHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqLocalHeadBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqServiceBean;
import com.irdstudio.efp.esb.common.client.req.EsbReqSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.client.ESBBeanCreator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="XhxESBBeanCreatorWithC_ScrtKeyEncd")
public class XhxESBBeanCreatorWithC_ScrtKeyEncd
implements ESBBeanCreator {
    private static final Logger log = LoggerFactory.getLogger(XhxESBBeanCreatorWithC_ScrtKeyEncd.class);
    private static final XhxESBBeanCreatorWithC_ScrtKeyEncd INSTANCE = new XhxESBBeanCreatorWithC_ScrtKeyEncd();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);
    private static DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateTimeFormatter timeForm = DateTimeFormatter.ofPattern("HHmmssSSS");

    @Override
    public EsbReqServiceBean create(String serverCode, String scene, Object body) throws Exception {
        EsbReqSysHeadBean sysHead = this.buildSysHead(serverCode, scene);
        EsbReqAppHeadBean appHead = this.buildAppHead();
        EsbReqLocalHeadBean localHead = this.buildLocalHead();
        EsbReqServiceBean reqBean = new EsbReqServiceBean();
        reqBean.setAppHead(appHead);
        reqBean.setSysHead(sysHead);
        reqBean.setLocalHead(localHead);
        reqBean.setBODY(body);
        return reqBean;
    }

    public static XhxESBBeanCreatorWithC_ScrtKeyEncd getINSTANCE() {
        return INSTANCE;
    }

    private XhxESBBeanCreatorWithC_ScrtKeyEncd() {
    }

    private EsbReqSysHeadBean buildSysHead(String serverCode, String scene) throws Exception {
        EsbReqSysHeadBean syshead = new EsbReqSysHeadBean();
        syshead.setSvcCd(serverCode);
        syshead.setScnCd(scene);
        syshead.setCnsmrSysID("2003000");
        syshead.setOrgnlCnsmrSysID("2003000");
        String globalSrlNo = TraceUtil.getTraceId();
        String consumerSrlNo = this.generateESBTradeSerialNo();
        syshead.setGlblSrlNo(globalSrlNo == null ? consumerSrlNo : globalSrlNo);
        syshead.setCnsmrSrlNo(consumerSrlNo);
        LocalDateTime date = LocalDateTime.now();
        syshead.setTxnDt(dateForm.format(date));
        syshead.setTxnTm(timeForm.format(date));
        syshead.setTxnMd(ESBClientConstance.TxnMd.ONLINE.name());
        syshead.setUsrLng(ESBClientConstance.UsrLng.CHINESE.name());
        syshead.setFileFlg(ESBClientConstance.FileFlg.NONE.VALUE);
        syshead.setEryptMd(ESBClientConstance.EryptMd.NONE.VALUE);
        syshead.setPlafmID("B00001");
        syshead.setCompany("9999");
        syshead.setOrgnlTmlIdNo("");
        syshead.setTmlIdNo("");
        syshead.setOrgnlCnsmrSvcNo("");
        syshead.setCnsmrSvcNo("");
        syshead.setMACVal("");
        syshead.setMACFctr("");
        syshead.setPINSd("");
        syshead.setSvcVerNo("");
        syshead.setVerfFlg("");
        syshead.setMsgTp("");
        syshead.setPltfmClntNo("");
        syshead.setPlafmUsrID("");
        syshead.setPrdctID("");
        syshead.setRelGlblSrlNo("");
        return syshead;
    }

    private EsbReqLocalHeadBean buildLocalHead() throws Exception {
        EsbReqLocalHeadBean localHead = new EsbReqLocalHeadBean();
        localHead.setC_ScrtKeyEncd("gzyh.teller_login.sm2");
        LocalDate date = LocalDate.now();
        localHead.setC_TrdPtyDt(dateForm.format(date));
        return localHead;
    }

    private EsbReqAppHeadBean buildAppHead() {
        EsbReqAppHeadBean appHead = new EsbReqAppHeadBean();
        appHead.setInstId("00090");
        appHead.setUsrNo("X0074");
        String cnlTp = TraceUtil.getCnlTp();
        if (cnlTp == null || "".equals(cnlTp)) {
            log.error("\u6e20\u9053\u53f7\u4e3a\u7a7a\uff01");
        }
        appHead.setCnlTp(cnlTp);
        appHead.setUsrPswd("");
        appHead.setUsrLvl("");
        appHead.setUsrTp("");
        appHead.setTlrSrlNo("");
        appHead.setCnlDtlTp("");
        appHead.setCnsmrTxnCd("");
        return appHead;
    }

    private String generateESBTradeSerialNo() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("ESB", pattern);
    }
}

