/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.mock.esb;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.ZXQueryReports;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.client.impl.MSESBBeanCreator;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEsbService<Q extends ZXQueryReports, P>
implements EsbService<Q, P> {
    private static Logger log = LoggerFactory.getLogger(BaseEsbService.class);
    private final Base64.Encoder encoder = Base64.getEncoder();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"ESB$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)10);

    protected void preProcess(Q reqBean) {
    }

    protected abstract P postProcess(Q var1, P var2) throws Exception;

    protected abstract String tradeNo();

    protected abstract String scene();

    protected abstract Function<String, P> converter();

    public final P service(Q reqBean) throws Exception {
        log.info("\u8c03\u7528ESB\u670d\u52a1\u5f00\u59cb\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a" + reqBean);
        this.preProcess(reqBean);
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(reqBean).withTradeNo(this.tradeNo()).withScene(this.scene()).withESBBeanFactory((MSESBBeanCreator)SpringContextUtils.getBean((String)"MSESBBeanCreator")).create().sendAndReceive();
            EsbRespSysHeadBean esbRespSysHeadBean = esbRespServiceBean.getSysHead();
            Object resBean = esbRespServiceBean.getBody(this.converter());
            if (!StringUtils.equals((CharSequence)((EsbRespRetInfBean)esbRespSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"000000")) {
                StringBuilder errMsg = new StringBuilder("\u8c03\u7528ESB\u670d\u52a1\u5f02\u5e38");
                Optional.of(esbRespSysHeadBean).map(e -> ((EsbRespRetInfBean)e.getRetInfArry().get(0)).getRetMsg()).ifPresent(s -> errMsg.append(",\u9519\u8bef\u4fe1\u606f: ").append((String)s));
                throw new ESBException(errMsg.toString());
            }
            return (P)this.postProcess(reqBean, resBean);
        }
        catch (ESBException e2) {
            log.error(e2.getMessage());
            throw e2;
        }
        catch (Exception e3) {
            log.error(e3.getMessage());
            throw new ESBException((Throwable)e3);
        }
    }

    public Map<String, Object> serviceMap(Q queryReports) throws Exception {
        return null;
    }
}

