/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.mock.yed;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.constant.SDicCertTypeEnum;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.efp.console.common.YedEnums;
import com.irdstudio.efp.cus.service.facade.AcctInfoDetailService;
import com.irdstudio.efp.cus.service.facade.AcctInfoService;
import com.irdstudio.efp.cus.service.vo.AcctInfoDetailVO;
import com.irdstudio.efp.cus.service.vo.AcctInfoVO;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.GjjInfoReqBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedGjjAccInfoReqBean;
import com.irdstudio.efp.esb.service.bo.req.yed.YedGjjCompnayInfoRequestBean;
import com.irdstudio.efp.esb.service.bo.resp.GjjInfoResponseBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjAccNoInfoResponseBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjAcctInfoDetailRespBean;
import com.irdstudio.efp.esb.service.bo.resp.yed.YedGjjCompanyInfoResponseBean;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.mock.esb.AbstractDisposeGjjInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="yedGzGjjDisposeService")
public class YedGzGjjDisposeServiceImpl
extends AbstractDisposeGjjInfo {
    private final Logger log = LoggerFactory.getLogger(YedGzGjjDisposeServiceImpl.class);
    @Autowired
    @Qualifier(value="yedCustAuthenticationService")
    private EsbService<YedGjjCompnayInfoRequestBean, YedGjjCompanyInfoResponseBean> yedCustAuthenticationService;
    @Autowired
    @Qualifier(value="yedQueryGjjInfoService")
    private EsbService<YedGjjAccInfoReqBean, YedGjjAccNoInfoResponseBean> yedQueryGjjInfoService;
    @Autowired
    @Qualifier(value="acctInfoDetailService")
    private AcctInfoDetailService acctInfoDetailService;
    @Autowired
    @Qualifier(value="acctInfoService")
    private AcctInfoService acctInfoService;

    @Override
    protected GjjInfoResponseBean dispose(GjjInfoReqBean req) throws Exception {
        YedGjjCompnayInfoRequestBean cus = new YedGjjCompnayInfoRequestBean();
        String identNo = req.getIdentNo();
        String identTp = req.getIdentTp();
        this.log.info("\u67e5\u8be2\u5e76\u5904\u7406\u5e7f\u5dde\u516c\u79ef\u91d1\u4fe1\u606f\u5f00\u59cb\uff0c\u8bc1\u4ef6\u53f7" + identNo);
        cus.setIdentNo(identNo);
        if (SDicCertTypeEnum.IDCARD.getValue().equalsIgnoreCase(identTp)) {
            cus.setIdentTp(EsbBizEnums.YedGjjIdentTp.DISPOSING.getValue());
        }
        cus.setBeQryPrsnNm(req.getNm());
        this.log.info("\u67e5\u8be2\u5e76\u5904\u7406\u5e7f\u5dde\u516c\u79ef\u91d1\u4fe1\u606f-\u53bb\u5916\u6570\u5e73\u53f0\u67e5\u516c\u79ef\u91d1\u8d26\u53f7");
        TraceUtil.setTraceId((String)req.getGlobalSerno());
        YedGjjCompanyInfoResponseBean cusResp = (YedGjjCompanyInfoResponseBean)this.yedCustAuthenticationService.service((Object)cus);
        if (!StringUtil.isNullorBank((String)cusResp.getPrvdntAcctNo())) {
            YedGjjAccInfoReqBean gjj = new YedGjjAccInfoReqBean();
            gjj.setPrvdntAcctNo(cusResp.getPrvdntAcctNo());
            this.log.info("\u67e5\u8be2\u5e76\u5904\u7406\u5e7f\u5dde\u516c\u79ef\u91d1\u4fe1\u606f-\u62ff\u516c\u79ef\u91d1\u8d26\u53f7\u53bb\u5916\u6570\u5e73\u53f0\u516c\u79ef\u91d1\u4fe1\u606f");
            YedGjjAccNoInfoResponseBean resp = (YedGjjAccNoInfoResponseBean)this.yedQueryGjjInfoService.service((Object)gjj);
            GjjInfoResponseBean gjjResp = this.setGjjInfoResp(resp);
            List<AcctInfoVO> acctInfoVOS = this.getAcctInfoVOS(identTp, identNo);
            this.setAcctInfo(gjjResp, req.getCtcTelNo(), acctInfoVOS);
            this.setAcctInfoDetail(gjjResp, acctInfoVOS);
            return gjjResp;
        }
        TraceUtil.clear();
        return null;
    }

    private GjjInfoResponseBean setGjjInfoResp(YedGjjAccNoInfoResponseBean resp) {
        GjjInfoResponseBean gjjResp = new GjjInfoResponseBean();
        List infoDetailList = resp.getPrvdntAcctInfArry();
        gjjResp.setIdentNo(resp.getIdentNo());
        gjjResp.setIdentTp(resp.getIdentTp());
        for (Map infoDetail : infoDetailList) {
            String object = JSONObject.toJSONString((Object)infoDetail);
            YedGjjAcctInfoDetailRespBean yedGjjAcctInfoLoanRespBean = (YedGjjAcctInfoDetailRespBean)JSONObject.parseObject((String)object, YedGjjAcctInfoDetailRespBean.class);
            gjjResp.setPrvdntAcctNo(yedGjjAcctInfoLoanRespBean.getPrvdntAcctNo1());
            gjjResp.setOpnAcctDt(yedGjjAcctInfoLoanRespBean.getOpnAcctDt());
            gjjResp.setPayStopDt(yedGjjAcctInfoLoanRespBean.getPayStopDt());
            gjjResp.setCrnMnthPayUnitNm(resp.getCorpNm());
            gjjResp.setCrnBal(new BigDecimal(yedGjjAcctInfoLoanRespBean.getCrnBal()));
        }
        gjjResp.setInfQrySrc(resp.getInfQrySrc());
        gjjResp.setCustNm(resp.getCustNm());
        gjjResp.setPrvdntAcctNo(resp.getPrvdntAcctNo());
        gjjResp.setPreTaxSlryTotAmt(new BigDecimal(resp.getPreTaxSlryTotAmt()));
        gjjResp.setMblNo(resp.getMblNo());
        gjjResp.setCorpNm(resp.getCorpNm());
        gjjResp.setUnitRgstNo(resp.getUnitRgstNo());
        gjjResp.setFrstTmsRgstyTm(resp.getFrstTmsRgstyTm());
        gjjResp.setOibc(resp.getOIBC());
        gjjResp.setBsnLicNo(resp.getBsnLicNo());
        gjjResp.setChrctrstcCd(resp.getChrctrstcCd());
        gjjResp.setCorpAddr(resp.getCorpAddr());
        gjjResp.setUnitPaySt(resp.getUnitPaySt());
        gjjResp.setUnitPayCapitlSrc(resp.getUnitPayCapitlSrc());
        gjjResp.setLglRprs(resp.getLglRprs());
        gjjResp.setUnitCtcMd(resp.getUnitCtcMd());
        return gjjResp;
    }

    private List<AcctInfoVO> getAcctInfoVOS(String certType, String certCode) throws Exception {
        AcctInfoVO acctInfo = new AcctInfoVO();
        acctInfo.setCertType(certType);
        acctInfo.setCertCode(certCode);
        acctInfo.setPrdId(YedEnums.PrdIdEnum.YED.getValue());
        return this.acctInfoService.queryCertCodeAndCertTypeAndPrdId(acctInfo);
    }

    private void setAcctInfoDetail(GjjInfoResponseBean accNoResp, List<AcctInfoVO> acctInfoVOS) throws Exception {
        AcctInfoDetailVO infoDetailVO = new AcctInfoDetailVO();
        infoDetailVO.setPrvdntAcctNo1(accNoResp.getPrvdntAcctNo());
        infoDetailVO.setOpnAcctDt(accNoResp.getOpnAcctDt());
        infoDetailVO.setPayStopDt(accNoResp.getPayStopDt());
        infoDetailVO.setCrnMnthPayUnitNm(accNoResp.getCorpNm());
        infoDetailVO.setCrnBal(accNoResp.getCrnBal());
        infoDetailVO.setCertCode(accNoResp.getIdentNo());
        infoDetailVO.setCertType(accNoResp.getIdentTp());
        if (acctInfoVOS != null && acctInfoVOS.size() >= 1) {
            this.acctInfoDetailService.updateByCert(infoDetailVO);
        } else {
            infoDetailVO.setPrdId(YedEnums.PrdIdEnum.YED.getValue());
            infoDetailVO.setRemark("\u767d\u540d\u5355\u5bfc\u5165\u63d2\u5165");
            infoDetailVO.setCreateTime(DateUtility.getCurrDateTime());
            this.acctInfoDetailService.insert(infoDetailVO);
        }
    }

    private void setAcctInfo(GjjInfoResponseBean accNoResp, String phone, List<AcctInfoVO> acctInfoVOS) throws Exception {
        AcctInfoVO acctInfo = new AcctInfoVO();
        acctInfo.setInfQrySrc(accNoResp.getInfQrySrc());
        acctInfo.setCustNm(accNoResp.getCustNm());
        acctInfo.setPrvdntAcctNo(accNoResp.getPrvdntAcctNo());
        acctInfo.setCertType(SDicCertTypeEnum.IDCARD.getValue());
        acctInfo.setCertCode(accNoResp.getIdentNo());
        acctInfo.setPreTaxSlryTotAmt(accNoResp.getPreTaxSlryTotAmt());
        acctInfo.setMblNo(StringUtil.isNullorBank((String)accNoResp.getMblNo()) ? phone : accNoResp.getMblNo());
        acctInfo.setCorpNm(accNoResp.getCorpNm());
        acctInfo.setUnitRgstNo(accNoResp.getUnitRgstNo());
        acctInfo.setFrstTmsRgstyTm(accNoResp.getFrstTmsRgstyTm());
        acctInfo.setOibc(accNoResp.getOibc());
        acctInfo.setBsnLicNo(accNoResp.getBsnLicNo());
        acctInfo.setChrctrstcCd(accNoResp.getChrctrstcCd());
        acctInfo.setCorpAddr(accNoResp.getCorpAddr());
        acctInfo.setUnitPaySt(accNoResp.getUnitPaySt());
        acctInfo.setUnitPayCapitlSrc(accNoResp.getUnitPayCapitlSrc());
        acctInfo.setLglRprs(accNoResp.getLglRprs());
        acctInfo.setUnitCtcMd(accNoResp.getUnitCtcMd());
        if (acctInfoVOS != null && acctInfoVOS.size() >= 1) {
            acctInfo.setId(acctInfoVOS.get(0).getId());
            this.acctInfoService.updateByPk(acctInfo);
        } else {
            acctInfo.setPrdId(YedEnums.PrdIdEnum.YED.getValue());
            acctInfo.setRemark("\u767d\u540d\u5355\u8865\u5f55\u65f6\u63d2\u5165\u6570\u636e");
            acctInfo.setCreateTime(DateUtility.getCurrDateTime());
            this.acctInfoService.insert(acctInfo);
        }
    }
}

