/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.mock.zx;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.bo.req.BaseZXReqBean;
import com.irdstudio.efp.esb.service.bo.req.ZXQueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.BaseZXResBean;
import com.irdstudio.efp.esb.service.bo.resp.zx.ZXResponseReport;
import com.irdstudio.efp.esb.service.client.ESBClientFactory;
import com.irdstudio.efp.esb.service.client.impl.MSESBBeanCreator;
import com.irdstudio.efp.esb.service.facade.zx.ZXService;
import com.irdstudio.efp.esb.service.mock.zx.ZXConfig;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public abstract class BaseZXService<Q extends ZXQueryReports, P extends ZXResponseReport>
implements ZXService<Q> {
    private static Logger log = LoggerFactory.getLogger(BaseZXService.class);
    public static final String ZX_SUCCESS_STATUS = "1";
    private final Base64.Encoder encoder = Base64.getEncoder();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"ZX$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)10);
    protected static ZXConfig config;

    public ZXVO service(Q queryReports, String userId) throws Exception {
        log.info("\u5904\u7406\u5361\u4e2d\u5fc3\u63a5\u53e3\u5f00\u59cb\uff0c \u8bf7\u6c42\u53c2\u6570\uff1a" + queryReports);
        ZXConfig local = config;
        String temp = local.getKey() + "," + local.getSystemId() + "," + userId;
        String pKey = new String(this.encoder.encode(DigestUtils.md5Digest((byte[])temp.getBytes(Charset.forName("UTF-8")))));
        BaseZXReqBean reqBean = new BaseZXReqBean.Builder().withSysId(local.getSystemId()).withUsrID(userId).withPKey(pKey).withRqsID(this.queryIdGenerate()).withQryRptsInfArry(Collections.singletonList(queryReports)).build();
        this.preProcess(reqBean);
        try {
            EsbRespServiceBean esbRespServiceBean = ESBClientFactory.buildClient().withBody(reqBean).withTradeNo(this.tradeNo()).withScene(this.scene()).withESBBeanFactory((MSESBBeanCreator)SpringContextUtils.getBean((String)"MSESBBeanCreator")).create().sendAndReceive();
            EsbRespSysHeadBean esbRespSysHeadBean = esbRespServiceBean.getSysHead();
            BaseZXResBean resBean = (BaseZXResBean)esbRespServiceBean.getBody(this.converter());
            if (!Objects.equals(esbRespSysHeadBean.getRetSt(), ZX_SUCCESS_STATUS)) {
                StringBuilder errMsg = new StringBuilder("\u8c03\u7528\u5361\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
                Optional.ofNullable(resBean).map(BaseZXResBean::getWrongInf).ifPresent(s -> errMsg.append(",\u9519\u8bef\u4fe1\u606f: ").append((String)s));
                throw new ESBException(errMsg.toString());
            }
            return this.postProcess(reqBean, resBean);
        }
        catch (ESBException e) {
            log.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ESBException((Throwable)e);
        }
    }

    protected void preProcess(BaseZXReqBean<Q> reqBean) {
    }

    protected abstract ZXVO postProcess(BaseZXReqBean<Q> var1, BaseZXResBean<P> var2) throws Exception;

    protected abstract String tradeNo();

    protected abstract String scene();

    protected abstract Function<String, BaseZXResBean<P>> converter();

    private String queryIdGenerate() throws Exception {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean((String)"defaultSeqService");
        return sequenceService.getPatternedSequence("ZX", pattern);
    }

    static void setConfig(ZXConfig config) {
        BaseZXService.config = config;
    }
}

