/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.mock.zx;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.efp.esb.service.bo.req.BaseZXReqBean;
import com.irdstudio.efp.esb.service.bo.req.ZX11001QueryReports;
import com.irdstudio.efp.esb.service.bo.resp.zx.BaseZXResBean;
import com.irdstudio.efp.esb.service.bo.resp.zx.ZX11001ResponseReport;
import com.irdstudio.efp.esb.service.mock.zx.BaseZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service(value="zx11001Service")
@DependsOn(value={"ZXConfig"})
public class ZX11001ServiceImpl
extends BaseZXService<ZX11001QueryReports, ZX11001ResponseReport> {
    private static Logger log = LoggerFactory.getLogger(ZX11001ServiceImpl.class);
    public static final String INTERFACE_ID = "11001";
    public static final String QUERY_TYPE = "A";

    @Override
    protected void preProcess(BaseZXReqBean<ZX11001QueryReports> reqBean) {
        ZX11001QueryReports queryReports = (ZX11001QueryReports)reqBean.getQryRptsInfArry().get(0);
        queryReports = new ZX11001QueryReports.Builder().buildWithExists(queryReports).withReportId(INTERFACE_ID).withQueryType(QUERY_TYPE).withCertType("10100").build();
        log.debug("\u8fdb\u5165\u9ed1\u540d\u5355\u67e5\u8be2\u63a5\u53e3\uff0c\u53c2\u6570\uff1a" + Objects.toString(queryReports));
    }

    @Override
    protected ZXVO postProcess(BaseZXReqBean<ZX11001QueryReports> reqBean, BaseZXResBean<ZX11001ResponseReport> resBean) throws ESBException {
        Optional.ofNullable(resBean.getRepRptsInfArry()).map(i -> (ZX11001ResponseReport)i.get(0)).orElseThrow(() -> new ESBException("\u9ed1\u540d\u5355\u63a5\u53e3\u67e5\u8be2\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01"));
        if (log.isDebugEnabled()) {
            log.debug("\u9ed1\u540d\u5355\u67e5\u8be2\u63a5\u53e3,\u8fdb\u884c\u540e\u5904\u7406\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a " + reqBean + ", \u8fd4\u56de\u7ed3\u679c\uff1a " + resBean);
        }
        return new ZXVO(Boolean.TRUE, (Object)resBean.getRepRptsInfArry());
    }

    @Override
    protected String tradeNo() {
        return "40130002";
    }

    @Override
    protected String scene() {
        return "01";
    }

    @Override
    protected Function<String, BaseZXResBean<ZX11001ResponseReport>> converter() {
        return i -> (BaseZXResBean)JSONObject.parseObject((String)i, (TypeReference)new TypeReference<BaseZXResBean<ZX11001ResponseReport>>(){}, (Feature[])new Feature[0]);
    }
}

