/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.esb.service.mock.zx;

import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.annotations.DisconfFileItem;
import com.baidu.disconf.client.common.annotations.DisconfUpdateService;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import com.irdstudio.efp.esb.service.mock.zx.BaseZXService;
import java.util.Base64;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="ZXConfig")
@DisconfFile(filename="zx.properties")
@DisconfUpdateService(classes={ZXConfig.class})
public class ZXConfig
implements InitializingBean,
IDisconfUpdate {
    @Value(value="${zx.systemId}")
    private String systemId;
    @Value(value="${zx.key}")
    private String key;
    @Value(value="${zx.validDay}")
    private String validDay;
    private final Base64.Encoder encoder = Base64.getEncoder();

    public void afterPropertiesSet() throws Exception {
        this.reload();
    }

    public void reload() throws Exception {
        BaseZXService.setConfig(this.copy());
    }

    protected ZXConfig copy() throws CloneNotSupportedException {
        ZXConfig newConfig = new ZXConfig();
        newConfig.setSystemId(this.systemId);
        newConfig.setKey(this.key);
        newConfig.setValidDay(this.validDay);
        return newConfig;
    }

    @DisconfFileItem(name="zx.systemId", associateField="systemId")
    public String getSystemId() {
        return this.systemId;
    }

    @DisconfFileItem(name="zx.key", associateField="key")
    public String getKey() {
        return this.key;
    }

    @DisconfFileItem(name="zx.validDay", associateField="validDay")
    public String getValidDay() {
        return this.validDay;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValidDay(String validDay) {
        this.validDay = validDay;
    }
}

