/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.limit.service.common;

import com.irdstudio.basic.framework.core.util.BigDecimalUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PrdParamVO;
import com.irdstudio.efp.console.service.vo.PrdRateStdVO;
import com.irdstudio.efp.console.service.vo.RateSchemeDetailVO;
import com.irdstudio.efp.limit.service.domain.LmtIndivApp;
import com.irdstudio.efp.limit.service.domain.LmtPrelist;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LmtIndivAppUtil {
    private static Logger logger = LoggerFactory.getLogger(LmtIndivAppUtil.class);

    public static LmtIndivApp setLmtIndivAppByLmtPrelist(LmtIndivApp lmtIndivApp, LmtPrelist lmtPrelist) {
        lmtIndivApp.setCusId(lmtPrelist.getCusId());
        lmtIndivApp.setCusName(lmtPrelist.getCusName());
        lmtIndivApp.setCertCode(lmtPrelist.getCertCode());
        lmtIndivApp.setCertType(lmtPrelist.getCertType());
        lmtIndivApp.setPrdId(lmtPrelist.getPrdId());
        lmtIndivApp.setApplyAmt("1".equals(lmtPrelist.getLmtType()) ? lmtPrelist.getWaitActAmt() : null);
        lmtIndivApp.setApproveAmt("1".equals(lmtPrelist.getLmtType()) ? lmtPrelist.getWaitActAmt() : null);
        lmtIndivApp.setApplyTerm(lmtPrelist.getTerm());
        lmtIndivApp.setApproveTerm(lmtPrelist.getTerm());
        lmtIndivApp.setTermType(lmtPrelist.getTermType());
        lmtIndivApp.setValidDays(lmtPrelist.getActValidDays());
        lmtIndivApp.setApplyRateY(lmtPrelist.getFixedRate());
        lmtIndivApp.setApproveRateY("1".equals(lmtPrelist.getLmtType()) ? lmtPrelist.getFixedRate() : null);
        lmtIndivApp.setCurrencyType("CNY");
        lmtIndivApp.setCusManager(lmtPrelist.getCusManager());
        lmtIndivApp.setMainBrId(lmtPrelist.getMainBrId());
        lmtIndivApp.setChargeoffBrId(lmtPrelist.getChargeoffBrId());
        lmtIndivApp.setLegalOrgCode(lmtPrelist.getLegalOrgCode());
        lmtIndivApp.setLegalOrgName(lmtPrelist.getLegalOrgName());
        lmtIndivApp.setApplyDate(null);
        lmtIndivApp.setActSts("0");
        lmtIndivApp.setCreateTime(TimeUtil.getCurrentDateTime());
        lmtIndivApp.setCreateUser(lmtPrelist.getCusManager());
        lmtIndivApp.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        lmtIndivApp.setLastUpdateUser(lmtPrelist.getCusManager());
        lmtIndivApp.setInvestigatorId(null);
        lmtIndivApp.setEndorseId(null);
        lmtIndivApp.setEndorseDate(null);
        lmtIndivApp.setApproveStatus("000");
        lmtIndivApp.setIsCreInfo("1");
        lmtIndivApp.setLmtType(lmtPrelist.getLmtType());
        lmtIndivApp.setAssureMeansMain(null);
        lmtIndivApp.setAssureMeans2(null);
        lmtIndivApp.setAssureMeans3(null);
        return lmtIndivApp;
    }

    public static PrdParamVO getPrdParamVO(LmtPrelist lmtPrelist) {
        PrdParamVO prdParamVO = new PrdParamVO();
        if (lmtPrelist != null) {
            prdParamVO.setPrdId(lmtPrelist.getPrdId());
            prdParamVO.setAmtApprFlow(true);
            prdParamVO.setAmtMeaMedol(true);
            prdParamVO.setContTemplate(true);
            prdParamVO.setCrdApprFlow(true);
            prdParamVO.setCrdMeaMedol(true);
            prdParamVO.setCreditForm(true);
            prdParamVO.setEleNucForm(true);
            return prdParamVO;
        }
        return null;
    }

    public static LmtIndivApp setRateY(LmtIndivApp lmtIndivApp, PrdRateStdVO prdRateStdVO, LmtPrelist lmtPrelist) {
        if (prdRateStdVO.getRate() != null && lmtIndivApp != null && lmtPrelist != null) {
            BigDecimal baseRate = prdRateStdVO.getRate();
            String floatWay = lmtPrelist.getIrFloatType();
            BigDecimal floatPct = lmtPrelist.getIrFloatPct();
            BigDecimal rateY = null;
            rateY = "1".equals(floatWay) ? baseRate.multiply(BigDecimal.ONE.add(floatPct)) : baseRate.multiply(BigDecimal.ONE.subtract(floatPct));
            rateY = BigDecimalUtil.cutOutDecimal((BigDecimal)rateY, (int)6);
            lmtIndivApp.setApplyRateY(rateY);
            lmtIndivApp.setApproveRateY(rateY);
        }
        return lmtIndivApp;
    }

    public static LmtIndivApp setLmtIndivAppByPrdInfo(LmtIndivApp lmtIndivApp, LmtPrelist lmtPrelist, PrdInfoVO prdInfoVO) {
        if (prdInfoVO == null) {
            return lmtIndivApp;
        }
        lmtIndivApp.setCyclicFlg(prdInfoVO.getCyclicWay());
        lmtIndivApp.setPrdCode(prdInfoVO.getPrdCode());
        lmtIndivApp.setPrdName(prdInfoVO.getPrdName());
        lmtIndivApp.setPrdType(prdInfoVO.getPrdThlDri());
        lmtIndivApp.setAssureMeansMain(prdInfoVO.getGuarWay());
        lmtIndivApp.setRepaymentMode(prdInfoVO.getRepayWay());
        lmtIndivApp.setRepaymentPeriod(new BigDecimal(prdInfoVO.getRepayCycle()));
        lmtIndivApp.setRepaymentPeriodType(prdInfoVO.getRepayCycleType());
        lmtIndivApp.setRepaymentDay(new BigDecimal(prdInfoVO.getRepayDay()));
        lmtIndivApp.setRepaymentDayType(prdInfoVO.getRepayDayType());
        lmtIndivApp.setLoanUseSub(prdInfoVO.getLoanUseType());
        lmtIndivApp.setRepaymentSrcDec("\u4e2a\u4eba\u6536\u5165");
        lmtIndivApp.setCaseCode(prdInfoVO.getCaseCode());
        lmtIndivApp.setCaseName(prdInfoVO.getCaseName());
        lmtIndivApp.setLoanUseType(prdInfoVO.getLoanUseGenere());
        return lmtIndivApp;
    }

    public static void setInfoByPrd(LmtPrelist lmtPrelist, PrdInfoVO prdInfoVO, RateSchemeDetailVO rateSchemeDetailVO) {
        if (Objects.nonNull((Object)lmtPrelist) && Objects.nonNull(prdInfoVO) && Objects.nonNull(rateSchemeDetailVO) && Objects.isNull(lmtPrelist.getIrMode())) {
            lmtPrelist.setIrMode(rateSchemeDetailVO.getRateModel());
        }
    }
}

