/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.limit.service.common;

import com.irdstudio.basic.framework.core.exception.PauseException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.console.service.vo.PrdRateStdVO;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.limit.service.domain.LmtPrelist;
import com.irdstudio.efp.limit.service.vo.PreCreStatus;
import com.irdstudio.efp.limit.service.vo.PreListAppListVO;
import com.irdstudio.efp.limit.service.vo.PreListAppVO;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreListAppUtil {
    private static Logger logger = LoggerFactory.getLogger(PreListAppUtil.class);

    public static PreListAppVO lmtVO2AppVO(PreListAppVO preListAppVO, LmtPrelist lmtPrelist) throws UnsupportedEncodingException {
        logger.debug("\u5f53\u524d\u88c5\u6362\u53c2\u6570\u4e3a:");
        preListAppVO.setCdtSerno(lmtPrelist.getPreSerno());
        preListAppVO.setCdtQuota(lmtPrelist.getActLmtAmt());
        preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
        preListAppVO.setCertCode(lmtPrelist.getCertCode());
        preListAppVO.setCreditType(lmtPrelist.getLmtType());
        preListAppVO.setCusId(lmtPrelist.getCusId());
        preListAppVO.setCusName(lmtPrelist.getCusName());
        preListAppVO.setPreTerm(lmtPrelist.getActValidDays().toString());
        preListAppVO.setTermUnit(lmtPrelist.getTermType());
        preListAppVO.setIsAllowMent(null);
        preListAppVO.setIsExistCont("2");
        preListAppVO.setPrdId(lmtPrelist.getPrdId());
        preListAppVO.setList(null);
        DecimalFormat df = new DecimalFormat("00.0000000");
        if (Objects.nonNull(lmtPrelist.getFixedRate())) {
            String rate = df.format(lmtPrelist.getFixedRate().doubleValue());
            if (Objects.nonNull(lmtPrelist.getFixedRate())) {
                preListAppVO.setRealityIrY(new BigDecimal(rate.substring(0, rate.length() - 1)));
            }
        }
        preListAppVO.setMngBrId(lmtPrelist.getLegalOrgCode());
        preListAppVO.setMngBrName(lmtPrelist.getLegalOrgName());
        String brchShrtName = lmtPrelist.getLegalOrgSimpleName();
        preListAppVO.setOrgShortName(brchShrtName == null ? lmtPrelist.getLegalOrgName() : brchShrtName);
        return preListAppVO;
    }

    public static PreListAppVO preCreStatus_Estimate(PreListAppVO preListAppVO, LmtPrelist lmtPrelist) {
        if ("2".equals(lmtPrelist.getLmtType())) {
            if ("10".equals(lmtPrelist.getStatus())) {
                switch (lmtPrelist.getCurOp()) {
                    case "00": {
                        preListAppVO.setPreCreStatus(PreCreStatus.APPLY_WAIT.getCode());
                        preListAppVO.setActCdt(new BigDecimal("0"));
                        preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                        break;
                    }
                    case "10": {
                        preListAppVO.setPreCreStatus(PreCreStatus.APPLY_DO.getCode());
                        preListAppVO.setActCdt(new BigDecimal("0"));
                        preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                    }
                }
                return preListAppVO;
            }
            if ("30".equals(lmtPrelist.getStatus()) && "00".equals(lmtPrelist.getCurOp())) {
                preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                preListAppVO.setPreCreStatus(PreCreStatus.ACTIVE_WAIT.getCode());
                preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
                preListAppVO.setCreditType("1");
                return preListAppVO;
            }
        } else if ("1".equals(lmtPrelist.getLmtType()) && "30".equals(lmtPrelist.getStatus()) && "00".equals(lmtPrelist.getCurOp())) {
            preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
            preListAppVO.setPreCreStatus(PreCreStatus.ACTIVE_WAIT.getCode());
            preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
            return preListAppVO;
        }
        if ("30".equals(lmtPrelist.getStatus())) {
            preListAppVO.setCreditType("1");
            switch (lmtPrelist.getCurOp()) {
                case "20": {
                    preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                    preListAppVO.setPreCreStatus(PreCreStatus.ACTIVE_DO.getCode());
                    preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
                    break;
                }
                case "30": {
                    preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                    preListAppVO.setPreCreStatus(PreCreStatus.MODIFY_DO.getCode());
                    preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
                    break;
                }
                case "31": {
                    preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                    preListAppVO.setPreCreStatus(PreCreStatus.MODIFY_FIN.getCode());
                    preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
                }
            }
        } else {
            if ("32".equals(lmtPrelist.getStatus())) {
                preListAppVO.setCreditType("1");
                switch (lmtPrelist.getCurOp()) {
                    case "00": {
                        preListAppVO.setCdtQuota(lmtPrelist.getActLmtAmt());
                        preListAppVO.setPreCreStatus(PreCreStatus.ACTIVE_ON.getCode());
                        preListAppVO.setActCdt(new BigDecimal("0"));
                    }
                }
                return preListAppVO;
            }
            if ("97".equals(lmtPrelist.getStatus())) {
                preListAppVO.setCreditType("1");
                preListAppVO.setCdtQuota(lmtPrelist.getLmtAmt());
                preListAppVO.setPreCreStatus(PreCreStatus.OPEN_ACCONUT_FAILED.getCode());
                preListAppVO.setActCdt(lmtPrelist.getWaitActAmt());
                return preListAppVO;
            }
            if ("90".equals(lmtPrelist.getStatus())) {
                preListAppVO.setCreditType("2");
                preListAppVO.setPreCreStatus("12");
            }
        }
        return preListAppVO;
    }

    public static PrdRateStdVO getPrdInfoId(LmtPrelist lmtPrelist) {
        String prdId = lmtPrelist.getPrdId();
        PrdRateStdVO prdRateStdVO = new PrdRateStdVO();
        prdRateStdVO.setRateTypeName("10");
        prdRateStdVO.setTerm(lmtPrelist.getTerm().intValue());
        return prdRateStdVO;
    }

    public static CtrLoanContVO getCtrLoanCont(PreListAppVO preListAppVO, LmtPrelist lmtPrelist) {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(lmtPrelist.getLmtSerno());
        ctrLoanContVO.setLmtContNo(lmtPrelist.getLmtContNo());
        return ctrLoanContVO;
    }

    public static PreListAppVO setRealityIrY(PreListAppVO preListAppVO, LmtPrelist lmtPrelist, BigDecimal baseRate) throws PauseException {
        if (Objects.isNull(baseRate)) {
            throw new PauseException("\u67e5\u8be2\u57fa\u51c6\u5229\u7387\u4e3a\u7a7a");
        }
        String irFloatType = lmtPrelist.getIrFloatType();
        BigDecimal irFloatPct = lmtPrelist.getIrFloatPct();
        DecimalFormat df = new DecimalFormat("00.0000000");
        BigDecimal rateY = null;
        if (StringUtil.isNotEmpty((String)irFloatType) && Objects.nonNull(irFloatPct)) {
            switch (irFloatType) {
                case "1": {
                    rateY = baseRate.multiply(BigDecimal.ONE.add(irFloatPct));
                    String rateA = df.format(rateY.doubleValue());
                    preListAppVO.setRealityIrY(new BigDecimal(rateA.substring(0, rateA.length() - 1)));
                    break;
                }
                case "2": {
                    rateY = baseRate.multiply(BigDecimal.ONE.subtract(irFloatPct));
                    String rateB = df.format(rateY.doubleValue());
                    preListAppVO.setRealityIrY(new BigDecimal(rateB.substring(0, rateB.length() - 1)));
                }
            }
        }
        return preListAppVO;
    }

    public static PreListAppVO setContAndLoanAccount(PreListAppVO preListAppVO, LmtPrelist lmtPrelist, CtrLoanContVO ctrLoanContVO) {
        preListAppVO.setIsExistCont(ctrLoanContVO != null && ctrLoanContVO.getContNo() != null ? "1" : "2");
        PreListAppListVO temp = new PreListAppListVO();
        temp.setLoanAccount(ctrLoanContVO != null && ctrLoanContVO.getLoanAccount() != null ? ctrLoanContVO.getLoanAccount() : null);
        preListAppVO.getList().add(temp);
        if (ctrLoanContVO != null && ctrLoanContVO.getLoanAccount() == null && "32".equals(lmtPrelist.getStatus())) {
            preListAppVO.setPreCreStatus(PreCreStatus.OPEN_ACCONUT_FAILED.getCode());
        }
        return preListAppVO;
    }
}

