/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.limit.service.common;

import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.cus.service.vo.CusPrelistRiskInfoVO;
import com.irdstudio.efp.cus.service.vo.CusRptCdtCardInfoVO;
import com.irdstudio.efp.cus.service.vo.CusRptLoanInfoVO;
import com.irdstudio.efp.cus.service.vo.CusRptOverdueDetailVO;
import com.irdstudio.efp.cus.service.vo.CusRptPromptInfoVO;
import com.irdstudio.efp.cus.service.vo.CusRptQueryDetailVO;
import com.irdstudio.efp.cus.service.vo.CusRptResultVO;
import com.irdstudio.efp.rule.common.enumeration.CardStatus;
import com.irdstudio.efp.rule.common.enumeration.CreditCardType;
import com.irdstudio.efp.rule.common.enumeration.CreditQueryType;
import com.irdstudio.efp.rule.common.enumeration.GuaranteeType;
import com.irdstudio.efp.rule.common.enumeration.LoanStatus;
import com.irdstudio.efp.rule.common.enumeration.LoanType;
import com.irdstudio.efp.rule.common.enumeration.RiskClassfyType;
import com.irdstudio.efp.rule.service.vo.BankInnerLoanEntity;
import com.irdstudio.efp.rule.service.vo.CreditCardEntity;
import com.irdstudio.efp.rule.service.vo.CreditCardOverdueEntity;
import com.irdstudio.efp.rule.service.vo.CreditQueryEntity;
import com.irdstudio.efp.rule.service.vo.PersonalCreditEntity;
import com.irdstudio.efp.rule.service.vo.RuleArgsEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RptRecod2RuleArgsEntityUtil {
    private static Logger logger = LoggerFactory.getLogger(RptRecod2RuleArgsEntityUtil.class);

    public static RuleArgsEntity getRuleArgsByRptRecod(CusRptResultVO cusRptResultVO, CusPrelistRiskInfoVO cusPrelistRiskInfoVo, String firstDisbDate) throws Exception {
        CreditCardOverdueEntity creditCardOverdueEntity;
        CreditCardOverdueEntity overdueEntity;
        int i;
        String repay_24state;
        ArrayList<CreditCardOverdueEntity> overdueInfos;
        CreditCardEntity creditCardEntity;
        String endDate;
        String preSerno = "";
        Object lmtPrelist = null;
        BigDecimal creditCardTotalAmt = new BigDecimal("0");
        BigDecimal sixAvgUsedAmt = new BigDecimal("0");
        CusRptPromptInfoVO cusRptPromptInfoVO = cusRptResultVO.getCusRptPromptInfoVo();
        List cardInfos = cusRptResultVO.getCusRptCdtCardInfoVo();
        List loanInfos = cusRptResultVO.getCusRptLoanInfoVo();
        List cusRptOverdueDetailVos = cusRptResultVO.getCusRptOverdueDetailVo();
        List cusRptQueryDetailVo = cusRptResultVO.getCusRptQueryDetailVo();
        int cardOverDueLJ = 0;
        int cardOverDueMaxLX = 0;
        RuleArgsEntity ruleArgsEntity = new RuleArgsEntity();
        PersonalCreditEntity personalCreditEntity = new PersonalCreditEntity();
        ArrayList<Object> querys = new ArrayList<Object>();
        if (Objects.nonNull(cusRptQueryDetailVo)) {
            for (CusRptQueryDetailVO vo : cusRptQueryDetailVo) {
                CreditQueryEntity creditQueryEntity = new CreditQueryEntity();
                creditQueryEntity.setQueryReason(RptRecod2RuleArgsEntityUtil.judgeQueryReason(vo.getQueryCase()));
                creditQueryEntity.setQueryDate(RptRecod2RuleArgsEntityUtil.getQueryDate(vo.getQueryTime()));
                creditQueryEntity.setBankNo(RptRecod2RuleArgsEntityUtil.getBankNo(vo.getQueryUser()));
                creditQueryEntity.setOperator(RptRecod2RuleArgsEntityUtil.getQueryUser(vo.getQueryUser()));
                querys.add(creditQueryEntity);
            }
        }
        personalCreditEntity.setQuerys(querys);
        ArrayList<CreditCardEntity> cards = new ArrayList<CreditCardEntity>();
        String regex = "\\d";
        if (Objects.nonNull(loanInfos)) {
            for (CusRptLoanInfoVO infoVO : loanInfos) {
                endDate = infoVO.getRepay24stateEnd();
                endDate = endDate.replaceAll("\\D", "") + "01";
                endDate = DateTool.formatDate((String)endDate, (String)"yyyy-MM-dd");
                creditCardEntity = new CreditCardEntity();
                creditCardEntity.setStartYearMonth(infoVO.getRepay24stateStart());
                creditCardEntity.setEndYearMonth(infoVO.getRepay24stateEnd());
                creditCardEntity.setLoanStatus(RptRecod2RuleArgsEntityUtil.getLoanStatus(infoVO.getLoanState()));
                creditCardEntity.setLoanBalAmt(infoVO.getLoanBalance());
                creditCardEntity.setCardType(CreditCardType.LOAN_CARD);
                creditCardEntity.setLoanType(RptRecod2RuleArgsEntityUtil.getLoanType(infoVO.getLoanPrd()));
                creditCardEntity.setTotalAmt(infoVO.getLoanAmount());
                creditCardEntity.setBankNo(infoVO.getLoanOrg());
                creditCardEntity.setRiskClassfy(RptRecod2RuleArgsEntityUtil.getRiskClassfyType(infoVO.getFiveLevel()));
                creditCardEntity.setGuarType(RptRecod2RuleArgsEntityUtil.getGuaranteeType(infoVO.getGuarType()));
                creditCardEntity.setCurrMonthUsedAmt(infoVO.getsPaymentAmt());
                creditCardEntity.setLastRepayNum(infoVO.getRepaymentCyc());
                overdueInfos = new ArrayList();
                repay_24state = infoVO.getRepay24state();
                if (StringUtil.isNotEmpty((String)repay_24state)) {
                    int len = repay_24state.length();
                    for (i = 0; i < len; ++i) {
                        overdueEntity = new CreditCardOverdueEntity();
                        char c = repay_24state.charAt(len - 1 - i);
                        String yearMonth = TimeUtil.addMonth((String)endDate, (int)(0 - i)).replaceAll("-", "").substring(0, 6);
                        overdueEntity.setOverDueDate(yearMonth);
                        if (String.valueOf(c).matches(regex)) {
                            overdueEntity.setLastOverdueMonth(Integer.parseInt(String.valueOf(c)));
                        } else {
                            overdueEntity.setLastOverdueMonth(0);
                        }
                        overdueInfos.add(overdueEntity);
                    }
                }
                if (Objects.nonNull(cusRptOverdueDetailVos)) {
                    for (CusRptOverdueDetailVO cusRptOverdueDetailVO : cusRptOverdueDetailVos) {
                        if (!infoVO.getLoanId().equals(cusRptOverdueDetailVO.getLoanId())) continue;
                        overdueEntity = new CreditCardOverdueEntity();
                        overdueEntity.setLastOverdueMonth(cusRptOverdueDetailVO.getLastOverdueMonth());
                        overdueEntity.setOverDueAmt(cusRptOverdueDetailVO.getOverdueAmt());
                        overdueEntity.setOverDueDate(cusRptOverdueDetailVO.getOverdueMonth());
                        overdueInfos.add(overdueEntity);
                    }
                }
                creditCardEntity.setOverdueInfos(overdueInfos);
                creditCardOverdueEntity = new CreditCardOverdueEntity();
                creditCardOverdueEntity.setOverDueAmt(infoVO.getCurrOverdueAmt());
                creditCardOverdueEntity.setLastOverdueMonth(infoVO.getCurrOverdueNum());
                creditCardEntity.setCurrentOver(creditCardOverdueEntity);
                cards.add(creditCardEntity);
            }
        }
        if (Objects.nonNull(cardInfos)) {
            for (CusRptCdtCardInfoVO cardInfoVO : cardInfos) {
                endDate = cardInfoVO.getRepay24stateEnd();
                endDate = endDate.replaceAll("\\D", "") + "01";
                endDate = DateTool.formatDate((String)endDate, (String)"yyyy-MM-dd");
                creditCardEntity = new CreditCardEntity();
                creditCardEntity.setCardType("1".equals(cardInfoVO.getCardType()) ? CreditCardType.DEBIT_CARD : CreditCardType.SEMI_CREDIT_CARD);
                creditCardEntity.setTotalAmt(cardInfoVO.getCardLimit());
                creditCardEntity.setLoanBalAmt(cardInfoVO.getCardLimit().subtract(cardInfoVO.getUsedAmt()));
                creditCardEntity.setBankNo(cardInfoVO.getCardLoanOrg());
                creditCardEntity.setCardStatus(RptRecod2RuleArgsEntityUtil.getCardStatus(cardInfoVO.getCardState()));
                creditCardEntity.setCardNo(cardInfoVO.getCardLoanId());
                overdueInfos = new ArrayList<CreditCardOverdueEntity>();
                repay_24state = cardInfoVO.getRepay24state();
                logger.info("\u8fd124\u4e2a\u6708\u8fd8\u6b3e\u60c5\u51b5\u4e3a: " + repay_24state);
                if (StringUtil.isNotEmpty((String)repay_24state)) {
                    int len = repay_24state.length();
                    for (i = 0; i < len; ++i) {
                        overdueEntity = new CreditCardOverdueEntity();
                        char c = repay_24state.charAt(len - 1 - i);
                        String yearMonth = TimeUtil.addMonth((String)endDate, (int)(0 - i)).replaceAll("-", "").substring(0, 6);
                        overdueEntity.setOverDueDate(yearMonth);
                        if (String.valueOf(c).matches(regex)) {
                            overdueEntity.setLastOverdueMonth(Integer.parseInt(String.valueOf(c)));
                        } else {
                            overdueEntity.setLastOverdueMonth(0);
                        }
                        overdueInfos.add(overdueEntity);
                    }
                }
                creditCardEntity.setOverdueInfos(overdueInfos);
                creditCardOverdueEntity = new CreditCardOverdueEntity();
                creditCardOverdueEntity.setOverDueAmt(cardInfoVO.getCurrOverdueAmt());
                creditCardOverdueEntity.setLastOverdueMonth(cardInfoVO.getCurrOverdueNum());
                creditCardEntity.setCurrentOver(creditCardOverdueEntity);
                cards.add(creditCardEntity);
                int cardOverDueMaxLXTmp = 0;
                String cardOverStatus = cardInfoVO.getRepay24state();
                char[] records = cardOverStatus.toCharArray();
                for (int k = 0; k < records.length; ++k) {
                    Character aa = new Character(records[k]);
                    if (Character.isDigit(aa.charValue())) {
                        ++cardOverDueLJ;
                        ++cardOverDueMaxLXTmp;
                        if (k != records.length - 1) continue;
                        cardOverDueMaxLX = cardOverDueMaxLXTmp > cardOverDueMaxLX ? cardOverDueMaxLXTmp : cardOverDueMaxLX;
                        cardOverDueMaxLXTmp = 0;
                        continue;
                    }
                    if (cardOverDueMaxLXTmp > cardOverDueMaxLX) {
                        cardOverDueMaxLX = cardOverDueMaxLXTmp;
                    }
                    cardOverDueMaxLXTmp = 0;
                }
            }
        }
        if (Objects.nonNull(cusRptPromptInfoVO)) {
            creditCardTotalAmt = creditCardTotalAmt.add(cusRptPromptInfoVO.getUNDLoanCardCreditLimit()).add(cusRptPromptInfoVO.getUNDSLoanCardCreditLimit());
            sixAvgUsedAmt = sixAvgUsedAmt.add(cusRptPromptInfoVO.getUNDLoanCardUsedAvg6()).add(cusRptPromptInfoVO.getUNDSLoanCardUsedAvg6());
        }
        personalCreditEntity.setSixAvgUsedAmt(sixAvgUsedAmt);
        personalCreditEntity.setCreditCardTotalAmt(creditCardTotalAmt);
        personalCreditEntity.setCards(cards);
        personalCreditEntity.setCardDebitOverdueAllNum(cardOverDueLJ);
        personalCreditEntity.setCardContiOverdueNum(cardOverDueMaxLX);
        if (Objects.nonNull(cusRptPromptInfoVO)) {
            personalCreditEntity.setLoanSpeTreansFlag(cusRptPromptInfoVO.getAssureRepayCount() > 0 || cusRptPromptInfoVO.getAssetDissCount() > 0);
        } else {
            personalCreditEntity.setLoanSpeTreansFlag(false);
        }
        BankInnerLoanEntity innerLoan = new BankInnerLoanEntity();
        if (cusPrelistRiskInfoVo != null) {
            innerLoan.setOverdueLoanFlag("1".equals(cusPrelistRiskInfoVo.getLoanOdInd()));
        } else {
            innerLoan.setOverdueLoanFlag(false);
        }
        if (!StringUtil.isNullorBank((String)firstDisbDate)) {
            innerLoan.setFirstDisbDate(firstDisbDate);
        }
        ruleArgsEntity.setCredit(personalCreditEntity);
        ruleArgsEntity.setInnerLoan(innerLoan);
        return ruleArgsEntity;
    }

    public static CreditQueryType judgeQueryReason(String queryCase) {
        String qCase;
        switch (qCase = queryCase == null ? "" : queryCase.trim()) {
            case "\u8d37\u6b3e\u5ba1\u6279": {
                return CreditQueryType.LOAN_APPR;
            }
            case "\u4fe1\u7528\u5361\u5ba1\u6279": {
                return CreditQueryType.CREDIT_CARD_APPR;
            }
            case "\u8d37\u540e\u7ba1\u7406": {
                return CreditQueryType.LOAN_AFTER_MANAGE;
            }
        }
        return CreditQueryType.OTHER;
    }

    public static String getQueryDate(String queryDate) {
        if (StringUtil.isEmpty((String)queryDate)) {
            return "";
        }
        String date = queryDate.replaceAll("\\D", "");
        date = date.substring(0, 8);
        date = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        return date;
    }

    public static String getBankNo(String queryUser) {
        if (StringUtil.isEmpty((String)queryUser)) {
            return "";
        }
        String[] arr = queryUser.split("/");
        return arr[0];
    }

    public static String getQueryUser(String queryUser) {
        if (StringUtil.isEmpty((String)queryUser)) {
            return "";
        }
        String[] arr = queryUser.split("/");
        return arr.length == 2 ? arr[1] : arr[0];
    }

    public static LoanType getLoanType(String loanPrd) {
        String type;
        String string = type = loanPrd == null ? "" : loanPrd.trim();
        if (type.indexOf("\u4e2a\u4eba\u6d88\u8d39\u8d37\u6b3e") != -1 || type.indexOf("\u6d88\u8d39\u8d37\u6b3e") != -1) {
            return LoanType.CONSUME;
        }
        if (type.indexOf("\u4e2a\u4eba\u7ecf\u8425\u6027\u8d37\u6b3e") != -1 || type.indexOf("\u7ecf\u8425\u6027\u8d37\u6b3e") != -1) {
            return LoanType.OPERATE;
        }
        if (type.indexOf("\u4e2a\u4eba\u4f4f\u623f\u8d37\u6b3e") != -1 || type.indexOf("\u4f4f\u623f\u8d37\u6b3e") != -1 || type.indexOf("\u4e2a\u4eba\u4f4f\u623f\u516c\u79ef\u91d1\u8d37\u6b3e") != -1 || type.indexOf("\u4f4f\u623f\u516c\u79ef\u91d1\u8d37\u6b3e") != -1 || type.indexOf("\u4e2a\u4eba\u5546\u7528\u623f\uff08\u5305\u62ec\u5546\u4f4f\u4e24\u7528\uff09\u8d37\u6b3e") != -1 || type.indexOf("\u5546\u7528\u623f\uff08\u5305\u62ec\u5546\u4f4f\u4e24\u7528\uff09\u8d37\u6b3e") != -1) {
            return LoanType.HOUSE;
        }
        return LoanType.OTHER;
    }

    public static CardStatus getCardStatus(String cardStatus) {
        String status;
        switch (status = cardStatus == null ? "" : cardStatus.trim()) {
            case "\u6b63\u5e38": {
                return CardStatus.NORMAL;
            }
            case "\u903e\u671f": {
                return CardStatus.OVERDUE;
            }
            case "\u5446\u8d26": {
                return CardStatus.BAD_DEBT;
            }
            case "\u51bb\u7ed3": {
                return CardStatus.FROZEN;
            }
            case "\u6b62\u4ed8": {
                return CardStatus.STOP_PAYMENT;
            }
            case "\u7ed3\u6e05": {
                return CardStatus.SETTLE;
            }
            case "\u5f02\u5e38": {
                return CardStatus.EXCEPTION;
            }
            case "\u6302\u5931": {
                return CardStatus.REPORT_LOSE;
            }
            case "\u9500\u6237": {
                return CardStatus.CACEL_ACCOUNT;
            }
            case "\u6838\u9500": {
                return CardStatus.CANCEL_AFTER_VERIFI;
            }
            case "\u672a\u6fc0\u6d3b": {
                return CardStatus.NO_ACTIVATION;
            }
        }
        return CardStatus.OTHER;
    }

    public static RiskClassfyType getRiskClassfyType(String fiveLevel) {
        String level;
        switch (level = fiveLevel == null ? "" : fiveLevel) {
            case "\u6b63\u5e38": {
                return RiskClassfyType.NORMAL_ONE;
            }
            case "\u5173\u6ce8": {
                return RiskClassfyType.FOCUS_ONE;
            }
            case "\u53ef\u7591": {
                return RiskClassfyType.SUSPICIOUS;
            }
            case "\u6b21\u7ea7": {
                return RiskClassfyType.SECONDARY;
            }
            case "\u635f\u5931": {
                return RiskClassfyType.LOSS;
            }
        }
        return RiskClassfyType.NONE;
    }

    public static GuaranteeType getGuaranteeType(String guarType) {
        if (StringUtils.isEmpty((String)guarType)) {
            return GuaranteeType.OTHER;
        }
        if (guarType.indexOf("\u514d\u62c5\u4fdd") != -1 || guarType.indexOf("\u4fe1\u7528") != -1) {
            return GuaranteeType.CREDIT;
        }
        if (guarType.indexOf("\u7ec4\u5408(\u4e0d\u542b\u4fdd\u8bc1)\u62c5\u4fdd") != -1) {
            return GuaranteeType.GUAR;
        }
        if (guarType.indexOf("\u62b5\u62bc\u62c5\u4fdd") != -1) {
            return GuaranteeType.MORTGAGE;
        }
        if (guarType.indexOf("\u8d28\u62bc\u62c5\u4fdd") != -1) {
            return GuaranteeType.PLEDGE;
        }
        return GuaranteeType.OTHER;
    }

    public static LoanStatus getLoanStatus(String loanStatus) {
        if (StringUtils.isEmpty((String)loanStatus)) {
            return LoanStatus.OTHER;
        }
        switch (loanStatus) {
            case "\u6b63\u5e38": {
                return LoanStatus.NORMAL;
            }
            case "\u7ed3\u6e05": {
                return LoanStatus.CLOSE_OVER;
            }
        }
        return LoanStatus.OTHER;
    }
}

