/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.limit.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.annotation.checkAnnotation.QueryParamsNullCheck;
import com.irdstudio.basic.framework.core.base.AbstractFrameworkService;
import com.irdstudio.basic.framework.core.base.DataOptionalAuthorityDao;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.bean.SedSynCusManageVO;
import com.irdstudio.basic.framework.core.exception.PauseException;
import com.irdstudio.basic.framework.core.exception.ValidateException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.limit.service.dao.LmtIndivAppDao;
import com.irdstudio.efp.limit.service.dao.LmtPrdContDao;
import com.irdstudio.efp.limit.service.dao.LmtPrelistDao;
import com.irdstudio.efp.limit.service.dao.LmtShowInfoDao;
import com.irdstudio.efp.limit.service.domain.LmtPrdCont;
import com.irdstudio.efp.limit.service.domain.LmtPrelist;
import com.irdstudio.efp.limit.service.domain.LmtShowInfo;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.limit.service.vo.LmtPrelistVO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="lmtPrdContService")
public class LmtPrdContServiceImpl
extends AbstractFrameworkService
implements LmtPrdContService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(LmtPrdContServiceImpl.class);
    @Autowired
    private LmtPrdContDao lmtPrdContDao;
    @Autowired
    private LmtIndivAppDao lmtIndivAppDao;
    @Autowired
    private LmtShowInfoDao lmtShowInfoDao;
    @Autowired
    private LmtPrelistDao lmtPrelistDao;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;

    public int insertLmtPrdCont(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u65b0\u589e\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        int num = 0;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            this.beanCopy(lmtPrdContVo, (Object)lmtPrdCont);
            num = this.lmtPrdContDao.insertLmtPrdCont(lmtPrdCont);
            logger.info("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        }
        catch (ValidateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            num = -1;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        return num;
    }

    public int deleteByPk(LmtPrdContVO inLmtPrdContVo) {
        logger.info("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + JSON.toJSONString((Object)inLmtPrdContVo));
        int num = 0;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(inLmtPrdContVo, (Object)lmtPrdCont));
            num = this.lmtPrdContDao.deleteByPk(lmtPrdCont);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u6761\u4ef6:" + JSON.toJSONString((Object)inLmtPrdContVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateByPk(LmtPrdContVO inLmtPrdContVo) {
        logger.info("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + JSON.toJSONString((Object)inLmtPrdContVo));
        int num = 0;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(inLmtPrdContVo, (Object)lmtPrdCont));
            lmtPrdCont.setLastUpdateTime(DateTool.getCurrentDateTime());
            num = this.lmtPrdContDao.updateByPk(lmtPrdCont);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u6761\u4ef6:" + JSON.toJSONString((Object)inLmtPrdContVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @QueryParamsNullCheck(objName="inLmtPrdContVo", queryParamNames={"lmtStatus", "lmtContNo", "lmtApplySeq"})
    public LmtPrdContVO queryByPk(LmtPrdContVO inLmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)inLmtPrdContVo));
        try {
            LmtPrdCont queryLmtPrdCont = new LmtPrdCont();
            queryLmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(inLmtPrdContVo, (Object)queryLmtPrdCont));
            LmtPrdCont queryRslLmtPrdCont = this.lmtPrdContDao.queryByPk(queryLmtPrdCont);
            if (Objects.nonNull((Object)queryRslLmtPrdCont)) {
                LmtPrdContVO outLmtPrdContVo = (LmtPrdContVO)this.beanCopy((Object)queryRslLmtPrdCont, new LmtPrdContVO());
                logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)outLmtPrdContVo));
                return outLmtPrdContVo;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @QueryParamsNullCheck(objName="lmtPrdContVo", queryParamNames={"lmtStatus", "lmtContNo", "lmtApplySeq", "cusId", "cusName", "certType", "certCode", "prdCode", "prdId"})
    public List<LmtPrdContVO> queryLmtPrdList(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryLmtPrdList(lmtPrdContVo);
        if (Objects.isNull(lmtPrdConts)) {
            logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a");
            return null;
        }
        logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryAllOwner(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryAllOwnerByPage(lmtPrdContVo);
            if (Objects.isNull(lmtPrdConts)) {
                logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return null;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryAllCurrOrg(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryAllCurrOrgByPage(lmtPrdContVo);
        if (Objects.isNull(lmtPrdConts)) {
            logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
            return null;
        }
        logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryAllCurrDownOrg(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryAllCurrDownOrgByPage(lmtPrdContVo);
        if (Objects.isNull(lmtPrdConts)) {
            logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
            return null;
        }
        logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryAllCurrOwnerPrd(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6743\u9650\u4e0b\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + lmtPrdContVo.toString());
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryAllCurrOwnerPrdByPage(lmtPrdContVo);
        if (Objects.isNull(lmtPrdConts)) {
            logger.info("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6743\u9650\u4e0b\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a\uff01");
            return null;
        }
        logger.info("\u5f53\u524d\u4ea7\u54c1\u79cd\u7c7b\u6743\u9650\u4e0b\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryPrdContProcess(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u5f53\u524d\u8f93\u5165\u7684\u53c2\u6570\u4e3a: " + JSON.toJSONString((Object)lmtPrdContVO));
        List list = null;
        String[] approveStatusArr = null;
        approveStatusArr = StringUtil.isEmpty((String)lmtPrdContVO.getApproveStatus()) ? new String[]{"111", "997", "998"} : new String[]{lmtPrdContVO.getApproveStatus()};
        try {
            List<LmtPrdCont> resultList = this.lmtPrdContDao.queryPrdContProcess(lmtPrdContVO, approveStatusArr);
            logger.info("\u989d\u5ea6\u6fc0\u6d3b\u8fdb\u5ea6\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a: " + JSON.toJSONString(resultList));
            this.pageSet(resultList, (BaseInfo)lmtPrdContVO);
            list = (List)this.beansCopy(resultList, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int updatePrdContStatus(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u8f93\u5165\u53c2\u6570\u4e3a: " + JSON.toJSONString((Object)lmtPrdContVo));
        int num = 0;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVo, (Object)lmtPrdCont));
            lmtPrdCont.setLastUpdateTime(DateTool.getCurrentDateTime());
            num = this.lmtPrdContDao.updatePrdContStatus(lmtPrdCont);
            logger.info("\u5f53\u524d\u4fee\u6539\u6761\u6570\u4e3a: " + num);
        }
        catch (Exception e) {
            num = -1;
            logger.info("\u4fee\u6539\u5931\u8d25!", (Throwable)e);
        }
        return num;
    }

    public boolean signPrdCont(String lmtContNo) throws Exception {
        logger.info("\u5f00\u59cb\u7b7e\u8ba2\u6388\u4fe1\u534f\u8bae\uff0clmtContNo=" + lmtContNo);
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont.setLmtContNo(lmtContNo);
            logger.info("\u67e5\u8be2\u6388\u4fe1\u534f\u8bae\u53c2\u6570\u4e3a: " + JSON.toJSONString((Object)((Object)lmtPrdCont)));
            LmtPrdCont lmtPrdContFromDB = this.lmtPrdContDao.queryByPk(lmtPrdCont);
            logger.info("\u67e5\u8be2\u6388\u4fe1\u534f\u8bae\u7ed3\u679c\u4e3a: " + JSON.toJSONString((Object)((Object)lmtPrdContFromDB)));
            if (Objects.nonNull((Object)lmtPrdContFromDB)) {
                if ("997".equals(lmtPrdContFromDB.getApproveStatus())) {
                    return true;
                }
                String openday = this.pubSysInfoService.getOpenday("1001");
                BigDecimal term = lmtPrdContFromDB.getTerm();
                int term_ = term == null ? 0 : term.intValue();
                String termType = lmtPrdContFromDB.getTermType();
                String expireDate = openday;
                if ("D".equals(termType)) {
                    expireDate = TimeUtil.addDay((String)openday, (int)term_);
                } else if ("M".equals(termType)) {
                    expireDate = TimeUtil.addMonth((String)openday, (int)term_);
                } else if ("Y".equals(termType)) {
                    expireDate = TimeUtil.addYear((String)openday, (int)term_);
                }
                lmtPrdCont.setStartDate(openday);
                lmtPrdCont.setExpireDate(TimeUtil.addDay((String)expireDate, (int)-1));
                lmtPrdCont.setSignDate(openday);
                lmtPrdCont.setLmtStatus("01");
                lmtPrdCont.setApproveStatus("997");
                lmtPrdCont.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                int count = this.lmtPrdContDao.updateByPk(lmtPrdCont);
                LmtPrelist lmtPrelist = new LmtPrelist();
                lmtPrelist.setLmtContNo(lmtContNo);
                LmtPrelistVO lmtPrelistVO = new LmtPrelistVO();
                lmtPrelistVO = (LmtPrelistVO)this.beanCopy((Object)lmtPrelist, lmtPrelistVO);
                logger.info(lmtContNo + "\u7b7e\u8ba2\u6388\u4fe1\u534f\u8bae\u7ed3\u679c\uff1a" + (count == 1 ? "success" : "failure"));
                if (count != 1) {
                    throw new PauseException("\u7b7e\u8ba2\u6388\u4fe1\u534f\u8bae\u5931\u8d25\uff0c\u6388\u4fe1\u534f\u8bae\u53f7\uff1a" + lmtContNo);
                }
            } else {
                logger.error("\u6839\u636e\u6388\u4fe1\u534f\u8bae\u53f7\u65e0\u6cd5\u83b7\u53d6\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\uff0c\u6388\u4fe1\u534f\u8bae\u53f7\uff1a" + lmtContNo);
                throw new PauseException("\u6839\u636e\u6388\u4fe1\u534f\u8bae\u53f7\u65e0\u6cd5\u83b7\u53d6\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\uff0c\u6388\u4fe1\u534f\u8bae\u53f7\uff1a" + lmtContNo);
            }
            LmtShowInfo lmtShowInfo = new LmtShowInfo();
            lmtShowInfo.setLmtSerno(lmtPrdContFromDB.getLmtApplySeq());
            lmtShowInfo.setLmtContNo(lmtPrdContFromDB.getLmtContNo());
            lmtShowInfo.setLmtExpireDate(lmtPrdCont.getExpireDate());
            lmtShowInfo.setLastUpdateTime(TimeUtil.getCurrentDateTime());
            this.lmtShowInfoDao.updateShowInfoByLmtSerno(lmtShowInfo);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u8ba2\u6388\u4fe1\u534f\u8bae\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new PauseException(e.getMessage());
        }
        return true;
    }

    public List<LmtPrdContVO> queryLmtPrdContsByLegal(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u7684\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryLmtPrdContsByLegalByPage(lmtPrdContVo);
            if (Objects.isNull(lmtPrdConts)) {
                logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return null;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u7684\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryLmtPrdContsForTerByLegal(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u7684\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<Object> list = new ArrayList<LmtPrdContVO>();
        try {
            List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryLmtPrdContsForTerByLegalByPage(lmtPrdContVo);
            if (Objects.isNull(lmtPrdConts)) {
                logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return null;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u6cd5\u4eba\u673a\u6784\u4e0b\u7684\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
            this.pageSet(lmtPrdConts, (BaseInfo)lmtPrdContVo);
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public DataOptionalAuthorityDao getDataAuthorityDao() {
        return this.lmtPrdContDao;
    }

    public LmtPrdContVO qryLmtPrdContByCondition(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u67e5\u8be2\u6570\u636e\u7684\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        LmtPrdContVO result = null;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVo, (Object)lmtPrdCont));
            lmtPrdCont = this.lmtPrdContDao.qryLmtPrdContByCondition(lmtPrdCont);
            if (Objects.nonNull((Object)lmtPrdCont)) {
                result = (LmtPrdContVO)this.beanCopy((Object)lmtPrdCont, new LmtPrdContVO());
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)result));
            } else {
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        logger.info("\u6839\u636e\u6761\u4ef6:" + JSON.toJSONString((Object)lmtPrdContVo) + " \u67e5\u8be2\u5f97\u7684\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString(result));
        return result;
    }

    public int inValidLmtProContOverExpireDate(String openDay) {
        LocalDate date = LocalDate.now();
        String msg1 = "\u5f00\u59cb\u5931\u6548\u8d85\u8fc7\u6388\u4fe1\u534f\u8bae\u5230\u671f\u7684\u8bb0\u5f55..." + date;
        logger.debug(msg1, (Object)"message {}");
        int num = 0;
        try {
            num = this.lmtPrdContDao.inValidLmtProContOverExpireDate(openDay);
        }
        catch (Exception e) {
            String msg2 = "\u5931\u6548\u8d85\u8fc7\u6388\u4fe1\u534f\u8bae\u5230\u671f\u7684\u8bb0\u5f55\u53d1\u751f\u9519\u8bef" + e;
            num = -1;
            logger.error(msg2, (Object)"message {}");
        }
        return num;
    }

    public LmtPrdContVO qryLmtPrdContByLmtApplySeq(String lmtApplySeq) {
        logger.info("\u67e5\u8be2\u4fe1\u606f\u5f00\u59cb\uff0c\u53c2\u6570\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + lmtApplySeq);
        LmtPrdContVO result = null;
        try {
            LmtPrdCont lmtPrdCont = this.lmtPrdContDao.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
            if (Objects.nonNull((Object)lmtPrdCont)) {
                result = (LmtPrdContVO)this.beanCopy((Object)lmtPrdCont, new LmtPrdContVO());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        logger.info("\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + lmtApplySeq + "\uff0c\u67e5\u8be2\u5f97\u7684\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)result));
        return result;
    }

    public int insertOrUpdateLmtPrdCont(List<LmtPrdContVO> list) {
        LocalDate today = LocalDate.now();
        String msg1 = "\u3010\u989d\u5ea6\u4fe1\u606f\u8868\u3011\u6570\u636e\u540c\u6b65\u5f00\u59cb..." + today;
        logger.info(msg1, (Object)"message{}");
        ArrayList<LmtPrdCont> lmtPrdContList = new ArrayList();
        int num = 0;
        try {
            lmtPrdContList = (List)this.beansCopy(list, LmtPrdCont.class);
            int delNum = this.lmtPrdContDao.batchDeleteLmtPrdContByLmtApplySeq(lmtPrdContList);
            num = this.lmtPrdContDao.batchInsertLmtPrdCont(lmtPrdContList);
            String num_msg = "\u3010\u989d\u5ea6\u4fe1\u606f\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u5904\u7406\u7ed3\u679c:" + num;
            logger.info(num_msg, (Object)"message{}");
        }
        catch (Exception e) {
            String msg2 = "\u3010\u989d\u5ea6\u4fe1\u606f\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + e;
            logger.error(msg2, (Object)"message{}");
            num = -1;
        }
        return num;
    }

    public LmtPrdContVO queryContractEle(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVO));
        try {
            LmtPrdCont queryLmtPrdCont = new LmtPrdCont();
            queryLmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVO, (Object)queryLmtPrdCont));
            LmtPrdCont queryRslLmtPrdCont = this.lmtPrdContDao.queryContractEle(queryLmtPrdCont);
            if (Objects.nonNull((Object)queryRslLmtPrdCont)) {
                LmtPrdContVO outLmtPrdContVo = (LmtPrdContVO)this.beanCopy((Object)queryRslLmtPrdCont, new LmtPrdContVO());
                logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)outLmtPrdContVo));
                return outLmtPrdContVo;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public LmtPrdContVO queryOneQuota(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVO));
        try {
            LmtPrdCont queryLmtPrdCont = new LmtPrdCont();
            queryLmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVO, (Object)queryLmtPrdCont));
            LmtPrdCont queryRslLmtPrdCont = this.lmtPrdContDao.queryOneQuota(queryLmtPrdCont);
            if (Objects.nonNull((Object)queryRslLmtPrdCont)) {
                LmtPrdContVO outLmtPrdContVo = (LmtPrdContVO)this.beanCopy((Object)queryRslLmtPrdCont, new LmtPrdContVO());
                logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + JSON.toJSONString((Object)outLmtPrdContVo));
                return outLmtPrdContVo;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<LmtPrdContVO> queryOneCus(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u67e5\u8be2\u4e2a\u4eba\u989d\u5ea6\u5f00\u59cb\uff01\u53c2\u6570\uff1a" + lmtPrdContVO);
        List<Object> list = new ArrayList<LmtPrdContVO>();
        String[] btchLmtStCd = null;
        try {
            if (!StringUtil.isNullorBank((String)lmtPrdContVO.getLmtStatus())) {
                btchLmtStCd = lmtPrdContVO.getLmtStatus().split(",");
            }
            LmtPrdCont queryLmtPrdCont = new LmtPrdCont();
            List<LmtPrdCont> queryLmtPrdConts = this.lmtPrdContDao.queryOneCus(queryLmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVO, (Object)queryLmtPrdCont)), btchLmtStCd);
            if (Objects.isNull(queryLmtPrdConts)) {
                logger.info("\u5f53\u524d\u67e5\u8be2\u4e2a\u4eba\u989d\u5ea6\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return null;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u4e2a\u4eba\u989d\u5ea6\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + queryLmtPrdConts.size());
            list = (List)this.beansCopy(queryLmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> qryLmtPrdContByCust(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u5f53\u524d\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u67e5\u8be2\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)lmtPrdContVO));
        List result = null;
        try {
            LmtPrdCont lmtPrdCont = new LmtPrdCont();
            lmtPrdCont = (LmtPrdCont)((Object)this.beanCopy(lmtPrdContVO, (Object)lmtPrdCont));
            List<LmtPrdCont> queryLmtPrdConts = this.lmtPrdContDao.qryLmtPrdContByCust(lmtPrdCont);
            if (Objects.isNull(queryLmtPrdConts)) {
                logger.info("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a\u3002");
                return result;
            }
            result = (List)this.beansCopy(queryLmtPrdConts, LmtPrdContVO.class);
            logger.info("\u6839\u636e\u6761\u4ef6\uff1a" + JSON.toJSONString((Object)lmtPrdContVO) + "\uff0c\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf" + result.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    public boolean batchUpdateCusManage(List<SedSynCusManageVO> sedSynCusManageVOList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u5ba2\u6237\u7ecf\u7406\u5f00\u59cb");
        boolean result = false;
        try {
            ArrayList list = new ArrayList();
            int num = this.lmtPrdContDao.batchUpdateCusManage(sedSynCusManageVOList);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5ba2\u6237\u7ecf\u7406\u53d8\u66f4\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u8868\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    public int countLmtProContByCertTypeAndCertNo(String certType, String certNo) {
        return this.lmtPrdContDao.countLmtProContByCertTypeAndCertNo(certType, certNo);
    }

    public List<LmtPrdContVO> queryAllLmtPrdCont(LmtPrdContVO lmtPrdContVO) {
        logger.info("\u5f53\u524d\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u67e5\u8be2\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)lmtPrdContVO));
        List<Object> list = new ArrayList<LmtPrdContVO>();
        LmtPrdCont lmtPrdCont = new LmtPrdCont();
        this.beanCopy(lmtPrdContVO, (Object)lmtPrdCont);
        try {
            List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryAllLmtPrdCont(lmtPrdCont);
            if (Objects.isNull(lmtPrdConts)) {
                logger.info("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u4e3a\u7a7a\u3002");
                return null;
            }
            logger.info("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public List<LmtPrdContVO> queryByLmtSeqs(@Param(value="list") List<String> list) {
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryByLmtSeqs(list);
        try {
            return (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<LmtPrdContVO> aplcOCMExstdCrLmt(LmtPrdContVO lmtPrdContVO) {
        List<Object> lmtPrdContVOS = new ArrayList<LmtPrdContVO>();
        try {
            lmtPrdContVOS = (List)this.beansCopy(this.lmtPrdContDao.aplcOCMExstdCrLmt((LmtPrdCont)((Object)this.beanCopy(lmtPrdContVO, (Object)new LmtPrdCont()))), LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u3010\u6388\u4fe1\u534f\u8bae\u8868\u3011\u67e5\u8be2\u540c\u4e00\u8bc1\u4ef6\u53f7\u7684\u6240\u6709\u6709\u6548\u989d\u5ea6\u4fe1\u606f\u51fa\u9519:", (Throwable)e);
        }
        return lmtPrdContVOS;
    }

    public int updateLmtStatus(String lmtStatus, String lmtContNo) {
        return this.lmtPrdContDao.updateLmtStatus(lmtStatus, lmtContNo);
    }

    public int updateLmtByCertCode(String certCode) {
        return this.lmtPrdContDao.updateLmtByCertCode(certCode);
    }

    public List<LmtPrdContVO> queryLmtPrdByCertCode(LmtPrdContVO lmtPrdContVo) {
        logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString((Object)lmtPrdContVo));
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryLmtPrdByCertCode(lmtPrdContVo);
        if (Objects.isNull(lmtPrdConts)) {
            logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a");
            return null;
        }
        logger.info("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + lmtPrdConts.size());
        ArrayList<LmtPrdContVO> list = new ArrayList();
        try {
            list = (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int updateLmtStatusFromLmtApplySeq(String lmtStatus, String lmtApplySeq) {
        return this.lmtPrdContDao.updateLmtStatusFromLmtApplySeq(lmtStatus, lmtApplySeq);
    }

    public List<LmtPrdContVO> queryCountsByOrg(LmtPrdContVO lmtPrdContVO) {
        List<LmtPrdCont> lmtPrdConts = this.lmtPrdContDao.queryCountsByOrg(lmtPrdContVO);
        try {
            return (List)this.beansCopy(lmtPrdConts, LmtPrdContVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<LmtPrdContVO>();
        }
    }

    public int insertOrUpdateLmtPrdContByHed(List<LmtPrdContVO> list) throws Exception {
        ArrayList<LmtPrdCont> lmtPrdContList = new ArrayList();
        int num = 0;
        logger.info("\u60e0e\u8d37\u6279\u91cf\u66f4\u65b0\u989d\u5ea6\u8868\u5f00\u59cb");
        try {
            lmtPrdContList = (List)this.beansCopy(list, LmtPrdCont.class);
            num = this.lmtPrdContDao.insertOrUpdateLmtPrdContByHed(lmtPrdContList);
        }
        catch (Exception e) {
            e.printStackTrace();
            num = -1;
            logger.error("\u60e0e\u8d37\u6279\u91cf\u66f4\u65b0\u989d\u5ea6\u8868\u53d1\u751f\u5f02\u5e38");
            throw new SQLException("\u60e0e\u8d37\u6279\u91cf\u66f4\u65b0\u989d\u5ea6\u8868\u53d1\u751f\u5f02\u5e38,\u8bf7\u6392\u67e5\u6570\u636e\u5e93\u72b6\u51b5\uff0c\u53bblimit.middle\u67e5\u770b\u65e5\u5fd7,\u6392\u67e5\u95ee\u9898,\u7136\u540e\u7eed\u8dd1" + e.getMessage());
        }
        return num;
    }
}

