/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTool {
    public static final String PATTERN_DEFAULT = "yyyy-MM-dd";
    public static final String PATTERN_DAYPATH = "yyyy\\MM\\dd\\";
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATETIME_COMPACT = "yyyyMMddHHmmss";
    public static final String PATTERN_DATETIME_COMPACT_SSS = "yyyyMMddHHmmssSSS";
    public static final String PATTERN_DATE_COMPACT = "yyyyMMdd";
    public static final String PATTERN_DATESHORT = "yyMMdd";
    public static final String PATTERN_YEARMONTH = "yyyyMM";
    private static final String[] MONTHS_STRING = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11);
    }

    public static int getMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static int getSecond(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    public static long getMillis(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTimeInMillis();
    }

    public static Date addDateWithDay(Date date, int day) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(DateTool.getMillis(date) + (long)day * 24L * 3600L * 1000L);
        return c.getTime();
    }

    public static Date addDateWithMilliSecond(Date date, long milliSecond) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(DateTool.getMillis(date) + milliSecond);
        return c.getTime();
    }

    public static int diffDate(Date date1, Date date2) {
        return (int)((DateTool.getMillis(date1) - DateTool.getMillis(date2)) / 86400000L);
    }

    public static long diffDateInMillis(Date date1, Date date2) {
        return DateTool.getMillis(date1) - DateTool.getMillis(date2);
    }

    public static String getDateTimeStr(Date date) {
        return DateTool.formatDate(date, PATTERN_DATETIME);
    }

    public static String getDateStr(Date date) {
        return DateTool.formatDate(date, PATTERN_DEFAULT);
    }

    public static String getCurrentDateTime() {
        return DateTool.formatDate(new Date(), PATTERN_DATETIME);
    }

    public static String getCurrentDateTimeSSS() {
        return DateTool.formatDate(new Date(), PATTERN_DATETIME_COMPACT_SSS);
    }

    public static String getCurrentDate() {
        return DateTool.formatDate(new Date(), PATTERN_DEFAULT);
    }

    public static Date getDateFromLongStr(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(PATTERN_DATETIME);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date getDateFromStr(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(PATTERN_DEFAULT);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static int getYearDays(Date date) {
        GregorianCalendar c = (GregorianCalendar)GregorianCalendar.getInstance();
        c.setTime(date);
        return c.isLeapYear(c.get(1)) ? 366 : 365;
    }

    public static int getMonthDays(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static boolean compareDateTime(Date date1, Date date2) {
        return !date1.before(date2) && !date2.before(date1);
    }

    public static boolean compareDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static Date parseDateUTC(String date) {
        date = date.substring(4);
        date = date.replace("UTC 0800 ", "");
        for (int i = 0; i < MONTHS_STRING.length; ++i) {
            if (!date.startsWith(MONTHS_STRING[i])) continue;
            date = date.replace(MONTHS_STRING[i], String.valueOf(i + 1));
            break;
        }
        SimpleDateFormat df = new SimpleDateFormat("MM dd HH:mm:ss yyyy");
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEndDay(Date date) {
        return String.valueOf(DateTool.getDateStr(date)) + " 23:59:59";
    }

    public static String formatDate(Date date, String pattern) {
        String result = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            result = df.format(date);
        }
        return result;
    }

    public static String getEndOfYearStr() {
        return String.valueOf(Calendar.getInstance().get(1)) + "-12-31";
    }

    public static String getTimeDescription(Date time) throws Exception {
        long tt = System.currentTimeMillis() - time.getTime();
        long t = tt / 3600000L;
        if (t > 24L) {
            String timeS = DateTool.getDateTimeStr(time);
            SimpleDateFormat df = new SimpleDateFormat(PATTERN_DEFAULT);
            tt = df.parse(df.format(new Date())).getTime() - df.parse(timeS.substring(0, 10)).getTime();
            long d = tt / 86400000L;
            if (d >= 3L) {
                return timeS;
            }
            if (d == 2L) {
                return "\u524d\u5929";
            }
            return "\u6628\u5929";
        }
        if (t > 0L) {
            return Long.toString(t) + "\u5c0f\u65f6";
        }
        t = tt / 60000L;
        if (t > 0L) {
            return Long.toString(t) + "\u5206\u949f";
        }
        return "\u521a\u521a";
    }

    public static String getSimpleDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(PATTERN_DATETIME).format(date);
    }

    public static Date parseSimpleDateTime(String dateTime) {
        if (dateTime == null || "".equals(dateTime.trim())) {
            return null;
        }
        try {
            return new SimpleDateFormat(PATTERN_DATETIME).parse(dateTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateTimeDaysAgo(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 0 - days);
        return cal.getTime();
    }

    public static Date parseDate(String date, String formate) {
        Date d = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(formate);
            d = formatter.parse(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static String formateDate(Date date, String formate) {
        String s = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(formate);
            s = formatter.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String formateDate(String formate) {
        String s = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(formate);
            s = formatter.format(new Date());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static Date string2Date(String value, String format) {
        if (value == null || "".equals(value)) {
            return null;
        }
        SimpleDateFormat sdf = DateTool.getFormat(format);
        Date date = null;
        try {
            value = DateTool.formatDate(value, format);
            date = sdf.parse(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    protected static SimpleDateFormat getFormat(String format) {
        if (format == null || "".equals(format)) {
            format = PATTERN_DATETIME;
        }
        return new SimpleDateFormat(format);
    }

    public static String getDate(String format) {
        Date date = new Date();
        return DateTool.formateDate(date, format);
    }

    public static String formatDate(String date, String format) {
        if (date == null || "".equals(date)) {
            return "";
        }
        Date dt = null;
        SimpleDateFormat inFmt = null;
        SimpleDateFormat outFmt = null;
        ParsePosition pos = new ParsePosition(0);
        if ((date = date.replace("-", "").replace(":", "")) == null || "".equals(date.trim())) {
            return "";
        }
        try {
            if (Long.parseLong(date) == 0L) {
                return "";
            }
        }
        catch (Exception nume) {
            return date;
        }
        try {
            switch (date.trim().length()) {
                case 14: {
                    inFmt = new SimpleDateFormat(PATTERN_DATETIME_COMPACT);
                    break;
                }
                case 12: {
                    inFmt = new SimpleDateFormat("yyyyMMddHHmm");
                    break;
                }
                case 10: {
                    inFmt = new SimpleDateFormat("yyyyMMddHH");
                    break;
                }
                case 8: {
                    inFmt = new SimpleDateFormat(PATTERN_DATE_COMPACT);
                    break;
                }
                case 6: {
                    inFmt = new SimpleDateFormat(PATTERN_YEARMONTH);
                    break;
                }
                default: {
                    return date;
                }
            }
            dt = inFmt.parse(date, pos);
            if (dt == null) {
                return date;
            }
            outFmt = format == null || "".equals(format.trim()) ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5") : new SimpleDateFormat(format);
            return outFmt.format(dt);
        }
        catch (Exception exception) {
            return date;
        }
    }
}

