/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.service.facade.SOrgService;
import com.irdstudio.sdk.admin.service.vo.SOrgVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SOrgController
extends AbstractController {
    @Autowired
    @Qualifier(value="sOrgServiceImpl")
    private SOrgService sOrgService;

    @RequestMapping(value={"/s/orgs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SOrgVO>> querySOrgAll(SOrgVO vo) {
        List<SOrgVO> outputVo = this.sOrgService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/org/{organno}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SOrgVO> queryByPk(@PathVariable(value="organno") String organno) {
        SOrgVO inVo = new SOrgVO();
        inVo.setOrganno(organno);
        SOrgVO outputVo = this.sOrgService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/org"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SOrgVO inSOrgVo) {
        if (Objects.nonNull((Object)inSOrgVo)) {
            inSOrgVo.setState("0");
        }
        int outputVo = this.sOrgService.updateByPk(inSOrgVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/org"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SOrgVO inSOrgVo) {
        int outputVo = this.sOrgService.updateByPk(inSOrgVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/org"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSOrg(@RequestBody SOrgVO inSOrgVo) {
        int outputVo = this.sOrgService.insertSOrg(inSOrgVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/org/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySTableSummary(Map<String, Object> params) {
        List<Map<String, Object>> outputVo = this.sOrgService.querySTableSummary(params);
        return this.getResponseData(outputVo);
    }
}

