/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.service.facade.SRolemoduleService;
import com.irdstudio.sdk.admin.service.vo.SRolemoduleVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SRolemoduleController
extends AbstractController {
    @Autowired
    @Qualifier(value="sRolemoduleServiceImpl")
    private SRolemoduleService sRolemoduleService;

    @RequestMapping(value={"/s/rolemodules"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRolemoduleVO>> querySRolemoduleAll(SRolemoduleVO vo) {
        List<SRolemoduleVO> outputVo = this.sRolemoduleService.queryAllOwnerByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/rolemodules/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRolemoduleVO>> querySRolemoduleAllNotPage(SRolemoduleVO vo) {
        List<SRolemoduleVO> outputVo = this.sRolemoduleService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/rolemodule/{roleno}/{moduleCode}/{envId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SRolemoduleVO> queryByPk(@PathVariable(value="roleno") String roleno, @PathVariable(value="moduleCode") String moduleCode, @PathVariable(value="envId") String envId) {
        SRolemoduleVO inVo = new SRolemoduleVO();
        inVo.setRoleno(roleno);
        inVo.setModuleCode(moduleCode);
        SRolemoduleVO outputVo = this.sRolemoduleService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/rolemodule"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SRolemoduleVO inSRolemoduleVo) {
        int outputVo = this.sRolemoduleService.deleteByPk(inSRolemoduleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/rolemodule"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SRolemoduleVO inSRolemoduleVo) {
        int outputVo = this.sRolemoduleService.updateByPk(inSRolemoduleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/rolemodule"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSRolemodule(@RequestBody SRolemoduleVO inSRolemoduleVo) {
        int outputVo = this.sRolemoduleService.insertSRolemodule(inSRolemoduleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/rolemodule/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSRoleRightTree(@RequestBody List<SRolemoduleVO> tree, @RequestParam(value="roleno") String roleno) {
        int outputVo = this.sRolemoduleService.saveSRolemodule(tree, roleno);
        return this.getResponseData(outputVo);
    }
}

