/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.service.facade.SRoleuserService;
import com.irdstudio.sdk.admin.service.vo.SRoleuserVO;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SRoleuserController
extends AbstractController {
    @Autowired
    @Qualifier(value="sRoleuserServiceImpl")
    private SRoleuserService sRoleuserService;

    @RequestMapping(value={"/s/roleusers"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleuserVO>> querySRoleuserAll(SRoleuserVO vo) {
        List<SRoleuserVO> outputVo = this.sRoleuserService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleuser/{roleno}/{actorno}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SRoleuserVO> queryByPk(@PathVariable(value="roleno") String roleno, @PathVariable(value="actorno") String actorno) {
        SRoleuserVO inVo = new SRoleuserVO();
        inVo.setRoleno(new String(roleno));
        inVo.setActorno(new String(actorno));
        SRoleuserVO outputVo = this.sRoleuserService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/roleuser"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.deleteByPk(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleuser"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.updateByPk(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roleuser"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSRoleuser(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.insertSRoleuser(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/role/user/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleuserVO>> querySRolesUser(SRoleuserVO inSRoleUserVo) {
        if (StringUtil.isNullorBank((String)inSRoleUserVo.getActorno())) {
            return this.getResponseData(null);
        }
        List<SRoleuserVO> outputVo = this.sRoleuserService.queryUserSetRoles(inSRoleUserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roles/user"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> setSRolesUser(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.setSRoleSUser(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roles/user/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveSRolesUser(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.saveSRolesUser(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/roles/user"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteSRolesUser(@RequestBody SRoleuserVO inSRoleuserVo) {
        int outputVo = this.sRoleuserService.deleteSRolesUser(inSRoleuserVo);
        return this.getResponseData(outputVo);
    }
}

