/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.init;

import com.irdstudio.sdk.admin.service.facade.SDicService;
import com.irdstudio.sdk.admin.service.facade.SModuleInfoService;
import com.irdstudio.sdk.admin.service.vo.SDicVO;
import com.irdstudio.sdk.admin.service.vo.SModuleInfoVO;
import com.irdstudio.sdk.ssm.init.InitDictCondition;
import com.irdstudio.sdk.ssm.util.PathUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={InitDictCondition.class})
@Component
public class InitForDict {
    private static Logger logger = LoggerFactory.getLogger(InitForDict.class);
    @Value(value="${sdk.initDict:true}")
    private boolean initDict = true;
    @Autowired
    @Qualifier(value="sDicService")
    private SDicService sDicService;
    @Autowired
    @Qualifier(value="sModuleInfoServiceImpl")
    private SModuleInfoService sModuleInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void initMethod() {
        if (!this.initDict) {
            return;
        }
        String dictFileFullPath = PathUtil.getProjectRootPath() + "ffres/dict/all.js";
        logger.info("\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e\u5230:" + dictFileFullPath);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dictFileFullPath), "UTF-8");
            StringBuffer sb = new StringBuffer();
            List<SDicVO> list = this.sDicService.queryAllDict();
            list.forEach(dic -> {
                logger.info("\u521d\u59cb\u5316\u5b57\u5178\u9879" + dic.getOpttype() + "...");
                List<SDicVO> options = this.sDicService.queryDictOption(dic.getOpttype());
                sb.append("var ").append(dic.getOpttype().toUpperCase());
                sb.append("=[");
                options.forEach(option -> sb.append("{\"enname\":\"").append(option.getEnname()).append("\",\"cnname\":\"").append(option.getCnname()).append("\"},"));
                if (',' == sb.charAt(sb.length() - 1)) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("];\r\n");
                sb.append("function formatter_").append(dic.getOpttype().toUpperCase()).append("(value, row, index){").append("return JLEUtil.formatter_dict(value,").append(dic.getOpttype().toUpperCase()).append(");").append("};\r\n");
            });
            osw.write(sb.toString());
        }
        catch (Exception e) {
            try {
                logger.error("\u6570\u636e\u5b57\u5178\u521d\u59cb\u5316\u51fa\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(osw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)osw);
        }
        IOUtils.closeQuietly((Writer)osw);
        logger.info("\u5b57\u5178\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6210!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void initPortalModule() {
        if (!this.initDict) {
            return;
        }
        String dictFileFullPath = PathUtil.getProjectRootPath() + "ffres/dict/modules.js";
        logger.info("\u521d\u59cb\u5316\u95e8\u6237\u6a21\u5757\u6570\u636e\u5230:" + dictFileFullPath);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dictFileFullPath), "UTF-8");
            StringBuffer sb = new StringBuffer();
            SModuleInfoVO param = new SModuleInfoVO();
            param.setSize(Integer.MAX_VALUE);
            List<SModuleInfoVO> list = this.sModuleInfoService.queryAllOwner(param);
            String dicName = "PORTAL_MODULE";
            logger.info("\u521d\u59cb\u5316\u95e8\u6237\u6a21\u5757" + list.size() + "...");
            sb.append("var ").append("PORTAL_MODULE");
            sb.append("=[");
            list.forEach(module -> sb.append("{").append("\"enname\":").append("\"").append(module.getModuleCode()).append("\"").append(",\"cnname\":").append("\"").append(module.getModuleTitle()).append("\"").append(",\"moduleName\":").append("\"").append(module.getModuleName()).append("\"").append(",\"moduleShort\":").append("\"").append(module.getModuleShort()).append("\"").append(",\"moduleUrl\":").append("\"").append(module.getModuleUrl()).append("\"").append(",\"moduleInner\":").append("\"").append(module.getModuleInner()).append("\"").append(",\"moduleOpen\":").append("\"").append(module.getModuleOpen()).append("\"").append("},"));
            if (',' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("];\r\n");
            sb.append("function formatter_").append("PORTAL_MODULE").append("(value, row, index){").append("return JLEUtil.formatter_dict(value,").append("PORTAL_MODULE").append(");").append("};\r\n");
            osw.write(sb.toString());
        }
        catch (Exception e) {
            try {
                logger.error("\u6570\u636e\u95e8\u6237\u6a21\u5757\u521d\u59cb\u5316\u51fa\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(osw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)osw);
        }
        IOUtils.closeQuietly((Writer)osw);
        logger.info("\u95e8\u6237\u6a21\u5757\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6210!");
    }
}

