/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.e4a.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.sdk.beans.core.exception.BizException;
import com.irdstudio.sdk.beans.core.util.DESCoderUtil;
import com.irdstudio.sdk.beans.core.util.MD5Util;
import com.irdstudio.sdk.beans.core.util.RSAUtils;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.URLUtil;
import com.irdstudio.sdk.beans.core.vo.DutyInfo;
import com.irdstudio.sdk.beans.core.vo.OrgInfo;
import com.irdstudio.sdk.beans.core.vo.ResourceCtrl;
import com.irdstudio.sdk.beans.core.vo.RoleInfo;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.e4a.common.constant.E4AConstant;
import com.irdstudio.sdk.beans.e4a.service.dao.E4ADao;
import com.irdstudio.sdk.beans.e4a.service.domain.PubSysInfo;
import com.irdstudio.sdk.beans.e4a.service.domain.SDuty;
import com.irdstudio.sdk.beans.e4a.service.domain.SOrg;
import com.irdstudio.sdk.beans.e4a.service.domain.SRole;
import com.irdstudio.sdk.beans.e4a.service.domain.SUser;
import com.irdstudio.sdk.beans.e4a.service.facade.E4AService;
import com.irdstudio.sdk.beans.e4a.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.e4a.service.vo.SMenuCtrlVO;
import com.irdstudio.sdk.beans.e4a.service.vo.SMenuUserVO;
import com.irdstudio.sdk.beans.e4a.service.vo.SMenuVO;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="e4aService")
public class E4AServiceImpl
implements E4AService {
    private static final Logger logger = LoggerFactory.getLogger(E4AServiceImpl.class);
    @Autowired
    private E4ADao e4aDao;
    @Autowired
    private StringRedisTemplate template;

    public AuthInfoVO authToken(AuthInfoVO authInfoVO) {
        AuthInfoVO authInfo = new AuthInfoVO();
        try {
            String rsaPassword = authInfoVO.getPassword();
            String password = "";
            try {
                password = new String(RSAUtils.decryptByPrivateKey((String)rsaPassword, (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg=="));
                authInfoVO.setPassword(password);
            }
            catch (Exception e) {
                logger.error("RSA\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
                throw new Exception("RSA\u89e3\u5bc6\u662f\u5931\u8d25" + e.getMessage());
            }
            SUser param = new SUser();
            param.setUserCode(authInfoVO.getUsercode());
            param.setUserPwd(MD5Util.getMD5ofStr((String)(authInfoVO.getUsercode() + password)));
            SUser user = this.e4aDao.queryByCodeAndPw(param);
            if (user != null && StringUtil.isNotEmpty((String)user.getUserCode())) {
                PubSysInfo sysInfo;
                List<SRole> sRoleList;
                List<SDuty> sDutyList;
                SOrg sOrgInfo;
                logger.debug("\u767b\u5f55\u6210\u529f\uff01");
                long timestamp = System.currentTimeMillis();
                UserInfo userInfo = new UserInfo();
                userInfo.setUserId(user.getUserCode());
                userInfo.setUserName(user.getUserName());
                String jsonStr = JSONObject.toJSONString((Object)userInfo);
                String token = DESCoderUtil.encrypt((String)jsonStr);
                String md5 = MD5Util.getMD5ofStr((String)URLUtil.md5((String)token, (Long)timestamp, (String)"123456"));
                SOrg legalOrgInfo = this.e4aDao.queryOrgByLegalOrgCode(user.getLegalOrgCode());
                if (legalOrgInfo != null) {
                    OrgInfo legalOrg = new OrgInfo();
                    legalOrg.setOrgCode(legalOrgInfo.getOrgCode());
                    legalOrg.setOrgName(legalOrgInfo.getOrgName());
                    legalOrg.setOrgLocation(legalOrgInfo.getLocation());
                    legalOrg.setOrgAreaCode(legalOrgInfo.getAreaCode());
                    userInfo.setLegalOrg(legalOrg);
                }
                if ((sOrgInfo = this.e4aDao.queryOrgByUserCode(user.getUserCode())) != null) {
                    OrgInfo orgInfo = new OrgInfo();
                    orgInfo.setOrgCode(sOrgInfo.getOrgCode());
                    orgInfo.setOrgName(sOrgInfo.getOrgName());
                    orgInfo.setOrgLocation(sOrgInfo.getLocation());
                    orgInfo.setOrgAreaCode(sOrgInfo.getAreaCode());
                    userInfo.setOrgInfo(orgInfo);
                }
                if ((sDutyList = this.e4aDao.queryDutyByUserCode(user.getUserCode())) != null && sDutyList.size() > 0) {
                    ArrayList<DutyInfo> dutyList = new ArrayList<DutyInfo>();
                    for (int i = 0; i < sDutyList.size(); ++i) {
                        SDuty duty = sDutyList.get(i);
                        DutyInfo dutyInfo = new DutyInfo();
                        dutyInfo.setDutyCode(duty.getDutyCode());
                        dutyInfo.setDutyName(duty.getDutyName());
                        dutyList.add(dutyInfo);
                    }
                    userInfo.setUserDutys(dutyList);
                }
                if ((sRoleList = this.e4aDao.queryRoleByUserCode(user.getUserCode())) != null && sRoleList.size() > 0) {
                    ArrayList<RoleInfo> roleList = new ArrayList<RoleInfo>();
                    for (int i = 0; i < sRoleList.size(); ++i) {
                        SRole role = sRoleList.get(i);
                        RoleInfo roleInfo = new RoleInfo();
                        roleInfo.setRoleCode(role.getRoleCode());
                        roleInfo.setRoleName(role.getRoleName());
                        roleList.add(roleInfo);
                    }
                    userInfo.setUserRoles(roleList);
                }
                ArrayList<ResourceCtrl> rescCtrls = new ArrayList<ResourceCtrl>();
                List<SMenuVO> menuList = this.e4aDao.queryUserRescData(user.getUserCode());
                List<SMenuCtrlVO> ctrlList = this.e4aDao.queryUserRescActData(user.getUserCode());
                if (menuList != null && ctrlList != null) {
                    for (int i = 0; i < menuList.size(); ++i) {
                        SMenuVO menuVO = menuList.get(i);
                        for (int j = 0; j < ctrlList.size(); ++j) {
                            SMenuCtrlVO ctrlVO = ctrlList.get(j);
                            if (!menuVO.getMenuId().equals(ctrlVO.getMenuId())) continue;
                            ResourceCtrl rc = new ResourceCtrl();
                            rc.setRescCode(menuVO.getMenuId());
                            rc.setRescDesc(menuVO.getMenuName());
                            rc.setLegalOrgCode(menuVO.getLegalOrgCode());
                            rc.setFuncId(menuVO.getFuncId());
                            rc.setRescUrl(menuVO.getFuncUrl());
                            rc.setRescParentCode(menuVO.getUpMenuId());
                            rc.setRescActCode(ctrlVO.getCtrlCode());
                            rc.setRescActDesc(ctrlVO.getCtrlName());
                            rescCtrls.add(rc);
                        }
                    }
                    userInfo.setMenuCtrls(rescCtrls);
                }
                if ((sysInfo = this.e4aDao.queryPubSystInfo()) != null) {
                    userInfo.setOpenday(sysInfo.getOpenday());
                }
                this.template.delete((Object)("user:session:key:" + authInfoVO.getSessionId()));
                this.template.opsForValue().set((Object)("user:session:key:" + authInfoVO.getSessionId()), (Object)JSONObject.toJSONString((Object)userInfo), (long)E4AConstant.TOKEN_TIMEOUT, TimeUnit.SECONDS);
                authInfo.setUsercode(authInfoVO.getUsercode());
                authInfo.setToken(token);
                authInfo.setSessionId(authInfoVO.getSessionId());
                authInfo.setTimestamp(Long.valueOf(timestamp));
                authInfo.setMd5(md5);
                authInfo.setUserInfo(userInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return authInfo;
    }

    public AuthInfoVO valifyToken(AuthInfoVO authInfoVO) {
        AuthInfoVO authInfo = null;
        try {
            UserInfo userInfo;
            String token = authInfoVO.getToken();
            String sessionId = authInfoVO.getSessionId();
            String md5 = authInfoVO.getMd5();
            Long timestamp = authInfoVO.getTimestamp();
            authInfo = new AuthInfoVO();
            if (StringUtils.isNotEmpty((CharSequence)token) && timestamp != null && StringUtils.isNotEmpty((CharSequence)md5)) {
                try {
                    String currentMd5 = MD5Util.getMD5ofStr((String)URLUtil.md5((String)token, (Long)timestamp, (String)"123456"));
                    if (!md5.equals(currentMd5)) {
                        logger.error("md5\u6821\u9a8c\u5931\u8d25 \uff0c\u9700\u6821\u9a8cmd5\u4e3a\uff1a" + md5 + ",\u76ee\u6807md5\u4e3a\uff1a" + currentMd5);
                        throw new BizException("md5 not invalid");
                    }
                    long currenttimemillis = System.currentTimeMillis();
                    long timeOut = currenttimemillis - Long.valueOf(timestamp);
                    if (timeOut <= E4AConstant.TtimestampTimeOut) {
                        String tokenJson = DESCoderUtil.decrypt((String)token);
                        UserInfo userInfo2 = (UserInfo)JSONObject.parseObject((String)tokenJson, UserInfo.class);
                        if (userInfo2 == null || userInfo2.getUserId() == null) {
                            throw new BizException("decode token error.");
                        }
                        this.template.expire((Object)("user:session:key:" + authInfoVO.getSessionId()), (long)E4AConstant.TOKEN_TIMEOUT, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    throw new Exception("token\u6821\u9a8c\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                }
            }
            if ((userInfo = (UserInfo)JSONObject.parseObject((String)((String)this.template.opsForValue().get((Object)("user:session:key:" + sessionId))), UserInfo.class)) == null || userInfo.getUserId() == null) {
                throw new Exception("session\u4fe1\u606f\u8fc7\u671f\uff0c\u65e0\u6cd5\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u51fa\u9519:" + sessionId);
            }
            authInfo.setCheckToken(true);
            authInfo.setUserInfo(userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u9a8c\u8bc1\u8fc7\u7a0b\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            authInfo = new AuthInfoVO();
            authInfo.setCheckToken(false);
        }
        return authInfo;
    }

    public boolean logout(AuthInfoVO authInfoVO) {
        boolean success = false;
        try {
            String sessionId = authInfoVO.getSessionId();
            if (sessionId != null && StringUtils.isNotEmpty((CharSequence)sessionId)) {
                this.template.delete((Object)("user:session:key:" + authInfoVO.getSessionId()));
            }
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public SMenuUserVO queryUserMenuInfo(String userCode) {
        SMenuUserVO menuUser = new SMenuUserVO();
        List<SMenuVO> consoleMenu = this.e4aDao.queryUserRescData(userCode);
        List<SMenuCtrlVO> consoleCtrls = this.e4aDao.queryUserRescActData(userCode);
        menuUser.setCtrls(consoleCtrls);
        menuUser.setMenus(consoleMenu);
        return menuUser;
    }

    public AuthInfoVO modifyUserPassword(AuthInfoVO authInfoVO) {
        AuthInfoVO authInfo = new AuthInfoVO();
        try {
            String password = authInfoVO.getPassword();
            String decodePassword = "";
            try {
                decodePassword = new String(RSAUtils.decryptByPrivateKey((String)password, (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg=="), "UTF-8");
            }
            catch (Exception e) {
                logger.error("RSA\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
            String newPassword = authInfoVO.getNewPassword();
            String decodeNewPassword = "";
            try {
                decodeNewPassword = new String(RSAUtils.decryptByPrivateKey((String)newPassword, (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg=="), "UTF-8");
            }
            catch (Exception e) {
                logger.error("RSA\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
            SUser param = new SUser();
            param.setUserCode(authInfoVO.getUsercode());
            param.setUserPwd(MD5Util.getMD5ofStr((String)(authInfoVO.getUsercode() + decodePassword)));
            SUser user = this.e4aDao.queryByCodeAndPw(param);
            if (user != null) {
                SUser changeParam = new SUser();
                changeParam.setUserCode(user.getUserCode());
                changeParam.setUserPwd(MD5Util.getMD5ofStr((String)(authInfoVO.getUsercode() + decodeNewPassword)));
                this.e4aDao.updateUserPassword(changeParam);
                authInfo.setChangeSuccess(true);
                authInfo.setMessage("\u5bc6\u7801\u4fee\u6539\u6210\u529f!");
            } else {
                logger.error("\u539f\u5bc6\u7801\u9519\u8bef\uff01");
                authInfo.setChangeSuccess(false);
                authInfo.setMessage("\u539f\u5bc6\u7801\u9519\u8bef!");
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5bc6\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
            authInfo.setChangeSuccess(false);
            authInfo.setMessage("\u4fee\u6539\u5bc6\u7801\u9519\u8bef!");
        }
        return authInfo;
    }

    public boolean cacheValidateCode(String clientId, String validateCode) {
        this.template.opsForValue().set((Object)("validate:code:key:" + clientId), (Object)validateCode, (long)E4AConstant.VALIDATE_CODE_TIMEOUT, TimeUnit.SECONDS);
        return true;
    }

    public boolean verifyCodeImage(String clientId, String imageCode) {
        String cacheImageCode = (String)this.template.opsForValue().get((Object)("validate:code:key:" + clientId));
        return StringUtil.isNotEmpty((String)cacheImageCode) && StringUtil.isNotEmpty((String)imageCode) && cacheImageCode.toLowerCase().equals(imageCode.toLowerCase());
    }
}

