/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.e4a.api.rest;

import com.irdstudio.sdk.beans.core.util.CookiesUtil;
import com.irdstudio.sdk.beans.core.util.RSAUtils;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.e4a.api.util.ValidateCode;
import com.irdstudio.sdk.beans.e4a.common.constant.ValidateCheck;
import com.irdstudio.sdk.beans.e4a.service.facade.TenantE4aService;
import com.irdstudio.sdk.beans.e4a.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.e4a.service.vo.SMenuUserVO;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.OutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantE4aController
extends AbstractController {
    private static Logger logger = LoggerFactory.getLogger(TenantE4aController.class);
    @Autowired
    @Qualifier(value="tenantE4aService")
    private TenantE4aService e4aService;

    @RequestMapping(value={"/oauth/token"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> authToken(@RequestBody AuthInfoVO authInfoVO) {
        boolean check = true;
        if (check) {
            authInfoVO.setSessionId(this.httpRequest.getSession().getId());
            AuthInfoVO authInfo = this.e4aService.authToken(authInfoVO);
            if (authInfo != null && StringUtil.isNotEmpty((String)authInfo.getToken())) {
                CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssoclient", (String)authInfo.getSessionId(), (int)-1);
                CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssottp", (String)String.valueOf(authInfo.getTimestamp()), (int)-1);
                CookiesUtil.addCookie((HttpServletResponse)this.httpResponse, (String)"ssomd5", (String)authInfo.getMd5(), (int)-1);
                return this.getResponseData(authInfo.getToken());
            }
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e\u6216\u7528\u6237\u5df2\u88ab\u6ce8\u9500");
            return data;
        }
        ResponseData data = this.getResponseData(null);
        data.setCode("900000");
        data.setMessage("\u56fe\u5f62\u6821\u9a8c\u7801\u9a8c\u8bc1\u5931\u8d25");
        return data;
    }

    @RequestMapping(value={"/session/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<UserInfo> getSessionInfo() {
        ResponseData data = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            userInfo.setMenuCtrls(null);
            data = this.getResponseData(userInfo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
            this.httpResponse.setStatus(401);
        }
        return data;
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> logout() {
        ResponseData data = null;
        try {
            Cookie[] cookies;
            AuthInfoVO vo = new AuthInfoVO();
            vo.setSessionId(CookiesUtil.getCookieValue((HttpServletRequest)this.httpRequest, (String)"ssoclient"));
            vo.setTimestamp(Long.valueOf(CookiesUtil.getCookieValue((HttpServletRequest)this.httpRequest, (String)"ssottp")));
            vo.setMd5(CookiesUtil.getCookieValue((HttpServletRequest)this.httpRequest, (String)"ssomd5"));
            this.httpRequest.getSession().removeAttribute("userInfo");
            this.httpRequest.getSession().invalidate();
            for (Cookie c : cookies = this.httpRequest.getCookies()) {
                if (!"ssoclient".equals(c.getName()) && !"ssottp".equals(c.getName()) && !"ssomd5".equals(c.getName())) continue;
                c.setMaxAge(0);
                this.httpResponse.addCookie(c);
            }
            logger.info("\u6e05\u7a7asession");
            data = this.getResponseData(this.e4aService.logout(vo));
        }
        catch (Exception e) {
            logger.error("\u767b\u51fa\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return data;
    }

    @RequestMapping(value={"/account/modifyUserPwd"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> changePasswrod(@RequestBody AuthInfoVO authInfoVO) {
        ResponseData data = null;
        String newPassword = authInfoVO.getNewPassword();
        String decodeNewPassword = "";
        try {
            decodeNewPassword = new String(RSAUtils.decryptByPrivateKey((String)newPassword, (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMBjBDzWtzUpby1NinGstLcCtXEHjSi2ZtbJfCANBGQuwK5AqKropmAAz/ywm4jXZLUlU5ecy7l3jbS8oUVL/4hvPhPGqOEuaCjCdqC4xNsAYHMg+983mUvnaYOab8K8q7Zg8IW9lXxi6U1MJ7G+6Ps6JZFRekBtpCq7m086MbK1AgMBAAECgYBFux3sFz8sa6o6V2KYtSqDMt4k68HEQeigbUMqMs2mqjN4dUMtP0oefezk//Y/8SI1biQQTeqhfK3GFqC1h0hEwHf5DmPnK/M5O2VjuT9VRDaLTe8IGja8Ntu0Z222cGp6VWMDpmGyjIz/dq8Qfvrd10GxRIq8haAeXLWQ6X22eQJBAOFXljyVqtBg2ZHz1DaE2w0coB5ocQgtfmBbXRS75Uui3hke6TSW1n5EPd8T/GiHxEdrmJbPWrK03o/Ur0AfulcCQQDaj6G/IZ2HEEjjk7p7iQUmVDt09fReYPpdZEoNlFUhiFSK1olFqo4Hp13NAmM3Fv6VGYmdSf/fI5acSjfAJavTAkBvPS2M+tU3yJee1R8NSshX0Km6WRRzVQHtzyxD7/1hOSUqgXfd3hhEfKuOU+9mKp9aImNRD0tWrLKxjex1WzRBAkBByOW4b9fIZYBq73Y75LwmE0hqJfXNyobRQXSArdsJ4sz/lR9wVqu1Zgz3vfY7CLLMEgm3zCQ197JHjJdHQI99AkEAioozD+L7kzE/BTs6f7m23ID8roBLBzHHOll2N3RTbuVEmicCdXLj8FUlvl9Q6AhpxjdSNgcYuFEy4MCJRz0Ldg=="), "UTF-8");
        }
        catch (Exception e) {
            logger.error("RSA\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u5bc6\u7801\u4fee\u6539\u5931\u8d25\uff08\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff09\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return data;
        }
        if (!ValidateCheck.validatePasswordRule((String)decodeNewPassword)) {
            data = this.getResponseData(false);
            data.setMessage("\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u6216\u7279\u6b8a\u5b57\u7b26(~!@#$%^&*)\u7684\u81f3\u5c11\u4e24\u79cd");
        } else {
            AuthInfoVO resultInfo = this.e4aService.modifyUserPassword(authInfoVO);
            if (resultInfo != null) {
                if (resultInfo.isChangeSuccess()) {
                    data = this.getResponseData(true);
                } else {
                    data = this.getResponseData(false);
                    data.setMessage(resultInfo.getMessage());
                }
            } else {
                data = this.getResponseData(false);
            }
        }
        return data;
    }

    @RequestMapping(value={"/account/menuandcontr"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<SMenuUserVO> menuAndContr() {
        ResponseData data = null;
        try {
            UserInfo userInfo = this.getUserInfo();
            SMenuUserVO vo = null;
            if (userInfo != null) {
                vo = this.e4aService.queryUserMenuInfo(userInfo.getUserId());
            }
            data = this.getResponseData(vo);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u83dc\u5355\u53ca\u63a7\u5236\u70b9\u6743\u9650\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return data;
    }

    @RequestMapping(value={"/codeImage"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> createCodeImage(@RequestParam(value="clientId") String clientId) {
        try {
            if (StringUtil.isNotEmpty((String)clientId)) {
                this.httpResponse.setContentType("image/jpeg");
                this.httpResponse.setHeader("Pragma", "no-cache");
                this.httpResponse.setHeader("Cache-Control", "no-cache");
                this.httpResponse.setDateHeader("Expires", 0L);
                ValidateCode vCode = new ValidateCode(120, 40, 4, 100);
                vCode.write((OutputStream)this.httpResponse.getOutputStream());
                this.e4aService.cacheValidateCode(clientId, vCode.getCode());
            } else {
                logger.error("verify code image error for: clientId is null");
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u56fe\u5f62\u6821\u9a8c\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/codeImage/verifyCodeImage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> verifyCodeImage(@RequestBody AuthInfoVO authInfoVO) {
        boolean check = false;
        try {
            String clientId = authInfoVO.getClientId();
            String imageCode = authInfoVO.getImageCode();
            check = this.e4aService.verifyCodeImage(clientId, imageCode);
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u56fe\u5f62\u7801\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.getResponseData(check);
    }
}

