/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.sdk.beans.excel.FileUtil;
import com.irdstudio.sdk.beans.excel.ObjectExcelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(String filePath, T object, Integer sheetNo, Integer headLine) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = FileUtil.getFileInputStream(filePath);
            List<T> list = ExcelUtil.readExcel(inputStream, object, sheetNo, headLine);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readExcel(String filePath, T object, Integer headLine) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = FileUtil.getFileInputStream(filePath);
            List<T> list = ExcelUtil.readAll(inputStream, object, headLine);
            return list;
        }
    }

    public static <T> List<T> readAll(InputStream inputStream, T object, Integer headLine) {
        ObjectExcelListener listener = new ObjectExcelListener();
        ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, object.getClass(), listener).headRowNumber(headLine)).sheet().doRead();
        return listener.getResult();
    }

    public static <T> List<T> readExcel(InputStream inputStream, T object, Integer sheetNo) {
        return ExcelUtil.readExcel(inputStream, object, sheetNo, (Integer)1);
    }

    public static <T> List<T> readExcel(InputStream inputStream, T object, Integer sheetNo, Integer headLine) {
        ObjectExcelListener listener = new ObjectExcelListener();
        ((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, object.getClass(), listener).headRowNumber(headLine)).sheet(sheetNo).doRead();
        return listener.getResult();
    }

    public static List<Map<Integer, String>> readExcelHeader(InputStream inputStream, Integer sheetNo, Integer headLine) {
        final ArrayList<Map<Integer, String>> headerList = new ArrayList<Map<Integer, String>>();
        AnalysisEventListener<Map<Integer, String>> listener = new AnalysisEventListener<Map<Integer, String>>(){

            public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                headerList.add(headMap);
            }

            public void invoke(Map<Integer, String> data, AnalysisContext context) {
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }
        };
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)listener).sheet(sheetNo).headRowNumber(headLine)).doRead();
        return headerList;
    }

    public static <T> void writeExcel(OutputStream outputStream, List<T> content) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, 1);
    }

    public static <T> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, sheetNo, 1);
    }

    public static <T> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo, Integer headLine) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, sheetNo, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo, String sheetName, boolean finish) throws IOException {
        if (content == null || content.isEmpty()) {
            return;
        }
        ExcelWriter writer = null;
        try {
            WriteSheet sheet = new WriteSheet();
            sheet.setSheetNo(sheetNo);
            sheet.setSheetName(sheetName);
            writer = ((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)outputStream).needHead(Boolean.valueOf(true))).build();
            writer.write(content, sheet);
        }
        finally {
            if (finish && writer != null) {
                writer.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeMultipleSheet(OutputStream outputStream, List<String> sheetNames, List<List<T>> contents) throws IOException {
        if (contents == null || contents.isEmpty() || contents.get(0).isEmpty()) {
            return;
        }
        ExcelWriter writer = EasyExcelFactory.write((OutputStream)outputStream).build();
        Class<?> clazz = contents.get(0).get(0).getClass();
        for (int i = 0; i < contents.size(); ++i) {
            List<T> content = contents.get(i);
            String sheetName = sheetNames.get(i);
            boolean finish = i == contents.size() - 1;
            try {
                WriteSheet sheet = new WriteSheet();
                sheet.setSheetNo(Integer.valueOf(i + 1));
                sheet.setSheetName(sheetName);
                writer.write(content, sheet);
                continue;
            }
            finally {
                if (finish && writer != null) {
                    writer.finish();
                }
            }
        }
    }

    public static boolean validateExcel(InputStream templateInput, InputStream validateInput, List<String> failList) {
        List<Map<Integer, String>> templateHeaderList = ExcelUtil.readExcelHeader(templateInput, 0, 1);
        List<Map<Integer, String>> validateHeaderList = ExcelUtil.readExcelHeader(validateInput, 0, 1);
        if (templateHeaderList.size() != validateHeaderList.size()) {
            return false;
        }
        boolean flag = true;
        for (int i = 0; i < templateHeaderList.size(); ++i) {
            Map<Integer, String> t = templateHeaderList.get(i);
            Map<Integer, String> v = validateHeaderList.get(i);
            int len = t.size();
            for (int c = 0; c < len; ++c) {
                String vVal;
                String tVal = t.get(c);
                if (StringUtils.equals((String)tVal, (String)(vVal = v.get(c)))) continue;
                flag = false;
                if (failList == null) break;
                failList.add(String.format("%s:%s", tVal, vVal));
            }
            if (!flag) break;
        }
        return flag;
    }

    public static boolean validateExcel(InputStream templateInput, InputStream validateInput) {
        return ExcelUtil.validateExcel(templateInput, validateInput, null);
    }
}

