/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.excel;

import com.irdstudio.sdk.beans.excel.ExcelUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ExcelWriteFactory<T> {
    private OutputStream outputStream;
    private List<T> content;
    private Integer sheetNo;
    private Integer headLine;
    private String sheetName;
    private Boolean finish;

    public ExcelWriteFactory(Builder<T> builder) {
        this.outputStream = ((Builder)builder).outputStream;
        this.content = ((Builder)builder).content;
        this.sheetNo = ((Builder)builder).sheetNo;
        this.headLine = ((Builder)builder).headLine;
        this.sheetName = ((Builder)builder).sheetName;
        this.finish = ((Builder)builder).finish;
    }

    public void write() throws IOException {
        ExcelUtil.writeExcel(this.outputStream, this.content, this.sheetNo, this.sheetName, this.finish);
    }

    public static <T> Builder<T> create(List<T> content) {
        return new Builder<T>().content(content);
    }

    public static class Builder<T> {
        private OutputStream outputStream;
        private List<T> content;
        private Integer sheetNo = 1;
        private Integer headLine = 1;
        private String sheetName;
        private Boolean finish = true;

        public Builder<T> outputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public Builder<T> content(List<T> content) {
            this.content = content;
            return this;
        }

        public Builder<T> sheetNo(Integer sheetNo) {
            this.sheetNo = sheetNo;
            return this;
        }

        public Builder<T> headLine(Integer headLine) {
            this.headLine = headLine;
            return this;
        }

        public Builder<T> sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder<T> finish(Boolean finish) {
            this.finish = finish;
            return this;
        }

        public void write() throws IOException {
            this.build().write();
        }

        public ExcelWriteFactory<T> build() {
            return new ExcelWriteFactory(this);
        }
    }
}

